/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.world.entity.animal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;

public record FlowerMobVariant(ResourceLocation textureLocation, BlockState blockState, ResourceKey<LootTable> shearingLootTable, HolderSet<Biome> biomes) {
    public static final Codec<FlowerMobVariant> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("asset_id").forGetter(FlowerMobVariant::textureLocation), (App)BlockState.CODEC.fieldOf("carried_block").forGetter(FlowerMobVariant::blockState), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("shearing_loot_table").forGetter(FlowerMobVariant::shearingLootTable), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).optionalFieldOf("biomes", (Object)HolderSet.empty()).forGetter(FlowerMobVariant::biomes)).apply((Applicative)instance, FlowerMobVariant::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FlowerMobVariant> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, FlowerMobVariant::textureLocation, (StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), FlowerMobVariant::blockState, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.LOOT_TABLE), FlowerMobVariant::shearingLootTable, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.BIOME), FlowerMobVariant::biomes, FlowerMobVariant::new);

    public FlowerMobVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<FlowerMobVariant> resourceKey, Block block) {
        this(entityType, resourceKey, block, (HolderSet<Biome>)HolderSet.empty());
    }

    public FlowerMobVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<FlowerMobVariant> resourceKey, Block block, Holder<Biome> biome) {
        this(entityType, resourceKey, block, (HolderSet<Biome>)HolderSet.direct((Holder[])new Holder[]{biome}));
    }

    public FlowerMobVariant(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<FlowerMobVariant> resourceKey, Block block, HolderSet<Biome> biomes) {
        this(FlowerMobVariant.getTextureLocation(entityType, resourceKey), block.defaultBlockState(), FlowerMobVariant.getShearingLootTable(entityType, resourceKey), biomes);
    }

    public static Codec<Holder<FlowerMobVariant>> codec(ResourceKey<Registry<FlowerMobVariant>> registryKey) {
        return RegistryFixedCodec.create(registryKey);
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Holder<FlowerMobVariant>> streamCodec(ResourceKey<Registry<FlowerMobVariant>> registryKey) {
        return ByteBufCodecs.holderRegistry(registryKey);
    }

    public static ResourceLocation transformTextureLocation(ResourceLocation resourceLocation) {
        return resourceLocation.withPath(string -> "textures/" + string + ".png");
    }

    public static ResourceLocation getTextureLocation(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<FlowerMobVariant> resourceKey) {
        String path = entityType.key().location().getPath();
        return resourceKey.location().withPath(string -> "entity/" + path + "/" + string + "_" + path);
    }

    public static ResourceKey<LootTable> getShearingLootTable(Holder.Reference<? extends EntityType<?>> entityType, ResourceKey<FlowerMobVariant> resourceKey) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceKey.location().withPath(string -> "shearing/" + entityType.key().location().getPath() + "/" + string));
    }
}

