/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2680;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3175;
import net.minecraft.class_4638;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import net.minecraft.class_6580;
import net.minecraft.class_6581;
import net.minecraft.class_6796;
import net.minecraft.class_6880;

public final class FlowerPatchFeatureHelper {
    private FlowerPatchFeatureHelper() {
    }

    public static void registerFlowerFeatureModification(Iterable<class_6880<class_6796>> vegetalDecoration, class_2680 blockState) {
        FlowerPatchFeatureHelper.registerFlowerFeatureModification(vegetalDecoration, Collections.singletonList(blockState));
    }

    public static void registerFlowerFeatureModification(Iterable<class_6880<class_6796>> vegetalDecoration, List<class_2680> blockStates) {
        for (class_6880<class_6796> holder : vegetalDecoration) {
            class_4638 randomPatchConfiguration;
            class_2975 blockConfigurationConfiguredFeature;
            class_3037 class_30372;
            class_3037 class_30373;
            class_2975 flowerConfiguredFeature = (class_2975)((class_6796)holder.comp_349()).comp_334().comp_349();
            if (flowerConfiguredFeature.comp_332() != class_3031.field_21219 || !((class_30373 = flowerConfiguredFeature.comp_333()) instanceof class_4638) || !((class_30372 = (blockConfigurationConfiguredFeature = (class_2975)((class_6796)(randomPatchConfiguration = (class_4638)class_30373).comp_155().comp_349()).comp_334().comp_349()).comp_333()) instanceof class_3175)) continue;
            class_3175 simpleBlockConfiguration = (class_3175)class_30372;
            class_4651 class_46512 = simpleBlockConfiguration.comp_156();
            if (class_46512 instanceof class_6580) {
                class_6580 noiseProvider = (class_6580)class_46512;
                FlowerPatchFeatureHelper.addNoiseProviderStates(noiseProvider, blockStates);
                break;
            }
            class_46512 = simpleBlockConfiguration.comp_156();
            if (class_46512 instanceof class_6581) {
                class_6581 noiseThresholdProvider = (class_6581)class_46512;
                FlowerPatchFeatureHelper.addNoiseThresholdProviderStates(noiseThresholdProvider, blockStates);
                break;
            }
            class_46512 = simpleBlockConfiguration.comp_156();
            if (class_46512 instanceof class_4657) {
                class_4657 weightedStateProvider = (class_4657)class_46512;
                FlowerPatchFeatureHelper.addWeightedStateProviderStates(weightedStateProvider, blockStates);
                break;
            }
            class_46512 = simpleBlockConfiguration.comp_156();
            if (!(class_46512 instanceof class_4656)) continue;
            class_4656 simpleStateProvider = (class_4656)class_46512;
            FlowerPatchFeatureHelper.addSimpleStateProviderStates(simpleBlockConfiguration, simpleStateProvider, blockStates);
            break;
        }
    }

    private static void addNoiseProviderStates(class_6580 noiseProvider, List<class_2680> blockStates) {
        noiseProvider.field_34712 = ImmutableList.builder().addAll((Iterable)noiseProvider.field_34712).addAll(blockStates).build();
    }

    private static void addNoiseThresholdProviderStates(class_6581 noiseThresholdProvider, List<class_2680> blockStates) {
        noiseThresholdProvider.field_34718 = ImmutableList.builder().addAll((Iterable)noiseThresholdProvider.field_34718).addAll(blockStates).build();
    }

    private static void addWeightedStateProviderStates(class_4657 weightedStateProvider, List<class_2680> blockStates) {
        List list = weightedStateProvider.field_21315.method_34994();
        class_6012.class_6006 builder = class_6012.method_66215();
        int maxWeight = 1;
        for (class_6010 blockStateWrapper : list) {
            int weight = blockStateWrapper.comp_2543();
            if (weight > maxWeight) {
                maxWeight = weight;
            }
            builder.method_34975((Object)((class_2680)blockStateWrapper.comp_2542()), weight);
        }
        for (class_2680 blockState : blockStates) {
            builder.method_34975((Object)blockState, maxWeight);
        }
        weightedStateProvider.field_21315 = builder.method_34974();
    }

    private static void addSimpleStateProviderStates(class_3175 simpleBlockConfiguration, class_4656 simpleStateProvider, List<class_2680> blockStates) {
        class_6012.class_6006 builder = class_6012.method_66215();
        builder.method_54453((Object)simpleStateProvider.field_21314);
        blockStates.forEach(arg_0 -> ((class_6012.class_6006)builder).method_54453(arg_0));
        simpleBlockConfiguration.comp_156 = new class_4657(builder.method_34974());
    }
}

