/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.util;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public final class FlowerPatchFeatureHelper {
    private FlowerPatchFeatureHelper() {
    }

    public static void registerFlowerFeatureModification(Iterable<Holder<PlacedFeature>> vegetalDecoration, BlockState blockState) {
        FlowerPatchFeatureHelper.registerFlowerFeatureModification(vegetalDecoration, Collections.singletonList(blockState));
    }

    public static void registerFlowerFeatureModification(Iterable<Holder<PlacedFeature>> vegetalDecoration, List<BlockState> blockStates) {
        for (Holder<PlacedFeature> holder : vegetalDecoration) {
            RandomPatchConfiguration randomPatchConfiguration;
            ConfiguredFeature blockConfigurationConfiguredFeature;
            FeatureConfiguration featureConfiguration;
            FeatureConfiguration featureConfiguration2;
            ConfiguredFeature flowerConfiguredFeature = (ConfiguredFeature)((PlacedFeature)holder.value()).feature().value();
            if (flowerConfiguredFeature.feature() != Feature.FLOWER || !((featureConfiguration2 = flowerConfiguredFeature.config()) instanceof RandomPatchConfiguration) || !((featureConfiguration = (blockConfigurationConfiguredFeature = (ConfiguredFeature)((PlacedFeature)(randomPatchConfiguration = (RandomPatchConfiguration)featureConfiguration2).feature().value()).feature().value()).config()) instanceof SimpleBlockConfiguration)) continue;
            SimpleBlockConfiguration simpleBlockConfiguration = (SimpleBlockConfiguration)featureConfiguration;
            BlockStateProvider blockStateProvider = simpleBlockConfiguration.toPlace();
            if (blockStateProvider instanceof NoiseProvider) {
                NoiseProvider noiseProvider = (NoiseProvider)blockStateProvider;
                FlowerPatchFeatureHelper.addNoiseProviderStates(noiseProvider, blockStates);
                break;
            }
            blockStateProvider = simpleBlockConfiguration.toPlace();
            if (blockStateProvider instanceof NoiseThresholdProvider) {
                NoiseThresholdProvider noiseThresholdProvider = (NoiseThresholdProvider)blockStateProvider;
                FlowerPatchFeatureHelper.addNoiseThresholdProviderStates(noiseThresholdProvider, blockStates);
                break;
            }
            blockStateProvider = simpleBlockConfiguration.toPlace();
            if (blockStateProvider instanceof WeightedStateProvider) {
                WeightedStateProvider weightedStateProvider = (WeightedStateProvider)blockStateProvider;
                FlowerPatchFeatureHelper.addWeightedStateProviderStates(weightedStateProvider, blockStates);
                break;
            }
            blockStateProvider = simpleBlockConfiguration.toPlace();
            if (!(blockStateProvider instanceof SimpleStateProvider)) continue;
            SimpleStateProvider simpleStateProvider = (SimpleStateProvider)blockStateProvider;
            FlowerPatchFeatureHelper.addSimpleStateProviderStates(simpleBlockConfiguration, simpleStateProvider, blockStates);
            break;
        }
    }

    private static void addNoiseProviderStates(NoiseProvider noiseProvider, List<BlockState> blockStates) {
        noiseProvider.states = ImmutableList.builder().addAll((Iterable)noiseProvider.states).addAll(blockStates).build();
    }

    private static void addNoiseThresholdProviderStates(NoiseThresholdProvider noiseThresholdProvider, List<BlockState> blockStates) {
        noiseThresholdProvider.highStates = ImmutableList.builder().addAll((Iterable)noiseThresholdProvider.highStates).addAll(blockStates).build();
    }

    private static void addWeightedStateProviderStates(WeightedStateProvider weightedStateProvider, List<BlockState> blockStates) {
        List list = weightedStateProvider.weightedList.unwrap();
        WeightedList.Builder builder = WeightedList.builder();
        int maxWeight = 1;
        for (Weighted blockStateWrapper : list) {
            int weight = blockStateWrapper.weight();
            if (weight > maxWeight) {
                maxWeight = weight;
            }
            builder.add((Object)((BlockState)blockStateWrapper.value()), weight);
        }
        for (BlockState blockState : blockStates) {
            builder.add((Object)blockState, maxWeight);
        }
        weightedStateProvider.weightedList = builder.build();
    }

    private static void addSimpleStateProviderStates(SimpleBlockConfiguration simpleBlockConfiguration, SimpleStateProvider simpleStateProvider, List<BlockState> blockStates) {
        WeightedList.Builder builder = WeightedList.builder();
        builder.add((Object)simpleStateProvider.state);
        blockStates.forEach(arg_0 -> ((WeightedList.Builder)builder).add(arg_0));
        simpleBlockConfiguration.toPlace = new WeightedStateProvider(builder.build());
    }
}

