/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.world.entity.ai.goal;

import fuzs.puzzleslib.api.entity.v1.EntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class BlockTrailRandomStrollGoal
extends WaterAvoidingRandomStrollGoal {
    private final int randomChance;

    public BlockTrailRandomStrollGoal(PathfinderMob pathfinderMob, double speedModifier) {
        this(pathfinderMob, speedModifier, 1000);
    }

    public BlockTrailRandomStrollGoal(PathfinderMob pathfinderMob, double speedModifier, int randomChance) {
        super(pathfinderMob, speedModifier);
        this.randomChance = randomChance;
    }

    protected abstract BlockState getBlockState();

    public void tick() {
        ServerLevel serverLevel = BlockTrailRandomStrollGoal.getServerLevel((Entity)this.mob);
        if (EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)this.mob) && !this.mob.isBaby() && serverLevel.random.nextInt(this.randomChance) == 0 && this.mob.getDeltaMovement().lengthSqr() > (double)1.0E-5f) {
            BlockPos blockPos = this.mob.blockPosition();
            BlockState blockState = this.getBlockState();
            if (serverLevel.getBlockState(blockPos).isAir() && blockState.canSurvive((LevelReader)serverLevel, blockPos)) {
                serverLevel.setBlockAndUpdate(blockPos, blockState);
                SoundType soundType = blockState.getSoundType();
                serverLevel.playSound(null, blockPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                serverLevel.gameEvent((Holder)GameEvent.BLOCK_PLACE, blockPos, GameEvent.Context.of((Entity)this.mob, (BlockState)blockState));
            }
        }
    }
}

