/*
 * Decompiled with CFR 0.152.
 */
package fuzs.bloomcraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import fuzs.bloomcraft.init.ModRegistry;
import fuzs.bloomcraft.world.entity.ai.goal.BlockTrailRandomStrollGoal;
import fuzs.bloomcraft.world.entity.animal.FlowerMobVariant;
import fuzs.bloomcraft.world.entity.animal.FlowerMobVariantUtil;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class Moobloom
extends Cow
implements Shearable,
VariantHolder<Holder<FlowerMobVariant>> {
    public static final EntityDataAccessor<Holder<FlowerMobVariant>> DATA_VARIANT = SynchedEntityData.defineId(Moobloom.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.MOOBLOOM_VARIANT_ENTITY_DATA_SERIALIZER.value()));
    @Nullable
    private UUID lastLightningBoltUUID;

    public Moobloom(EntityType<? extends Cow> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.removeAllGoals(WaterAvoidingRandomStrollGoal.class::isInstance);
        this.goalSelector.addGoal(5, (Goal)new BlockTrailRandomStrollGoal(this, 1.0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        Registry registry = this.registryAccess().lookupOrThrow(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY);
        builder.define(DATA_VARIANT, (Object)((Holder)registry.getAny().orElseThrow()));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.is(Items.BOWL) && !this.isBaby() && this.age == 0) {
            Block block = ((FlowerMobVariant)this.getVariant().value()).blockState().getBlock();
            if (block instanceof SuspiciousEffectHolder) {
                SuspiciousEffectHolder suspiciousEffectHolder = (SuspiciousEffectHolder)block;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    SuspiciousStewEffects stewEffects = suspiciousEffectHolder.getSuspiciousEffects();
                    ItemStack itemStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
                    itemStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)stewEffects);
                    ItemStack newItemInHand = ItemUtils.createFilledResult((ItemStack)itemInHand, (Player)player, (ItemStack)itemStack, (boolean)false);
                    player.setItemInHand(hand, newItemInHand);
                    this.setAge(6000);
                    for (int j = 0; j < 4; ++j) {
                        serverLevel.addParticle((ParticleOptions)ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                    }
                    this.playSound(SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY, 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (itemInHand.is(Items.SHEARS) && this.readyForShearing()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.shear(serverLevel, SoundSource.PLAYERS, itemInHand);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                itemInHand.hurtAndBreak(1, (LivingEntity)player, Moobloom.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        Holder<FlowerMobVariant> variant;
        if (spawnGroupData instanceof FlowerMobVariantUtil.VariantGroupData) {
            FlowerMobVariantUtil.VariantGroupData variantGroupData = (FlowerMobVariantUtil.VariantGroupData)((Object)spawnGroupData);
            variant = variantGroupData.variant;
        } else {
            Holder biome = level.getBiome(this.blockPosition());
            variant = FlowerMobVariantUtil.getSpawnVariant((Registry<FlowerMobVariant>)this.registryAccess().lookupOrThrow(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY), (Holder<Biome>)biome, level.getRandom());
            spawnGroupData = new FlowerMobVariantUtil.VariantGroupData(variant);
        }
        this.setVariant(variant);
        return super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
        UUID uuid = lightningBolt.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            Registry registry = this.registryAccess().lookupOrThrow(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY);
            int newIndex = (registry.getIdOrThrow((Object)((FlowerMobVariant)this.getVariant().value())) + 1) % registry.size();
            this.setVariant((Holder<FlowerMobVariant>)((Holder)registry.get(newIndex).orElseThrow(NoSuchElementException::new)));
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    public void shear(ServerLevel serverLevel, SoundSource soundSource, ItemStack shearsItemStack) {
        serverLevel.playSound(null, (Entity)this, SoundEvents.MOOSHROOM_SHEAR, soundSource, 1.0f, 1.0f);
        this.convertTo(EntityType.COW, ConversionParams.single((Mob)this, (boolean)false, (boolean)false), cow -> {
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(serverLevel, ((FlowerMobVariant)this.getVariant().value()).shearingLootTable(), shearsItemStack, (serverLevelX, itemStackX) -> {
                for (int i = 0; i < itemStackX.getCount(); ++i) {
                    serverLevelX.addFreshEntity((Entity)new ItemEntity((Level)serverLevelX, this.getX(), this.getY(1.0), this.getZ(), itemStackX.copyWithCount(1)));
                }
            });
        });
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    public void setVariant(Holder<FlowerMobVariant> variant) {
        this.entityData.set(DATA_VARIANT, variant);
    }

    public Holder<FlowerMobVariant> getVariant() {
        return (Holder)this.entityData.get(DATA_VARIANT);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        FlowerMobVariant.codec(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY).encodeStart((DynamicOps)NbtOps.INSTANCE, this.getVariant()).ifSuccess(tagX -> tag.put("variant", tagX));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        FlowerMobVariant.codec(ModRegistry.MOOBLOOM_VARIANT_REGISTRY_KEY).parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("variant")).ifSuccess(this::setVariant);
    }

    @Nullable
    public Moobloom getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Moobloom cluckbloom = (Moobloom)this.getType().create((Level)level, EntitySpawnReason.BREEDING);
        if (cluckbloom != null) {
            cluckbloom.setVariant(this.getVariant());
        }
        return cluckbloom;
    }
}

