/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.client.render.entity.state.MoobloomRenderState;
import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public final class MoobloomFlowerFeatureRenderer
extends RenderLayer<MoobloomRenderState, CowModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MoobloomFlowerFeatureRenderer(RenderLayerParent<MoobloomRenderState, CowModel> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, MoobloomRenderState moobloomRenderState, float yRot, float xRot) {
        MoobloomEntity moobloom = moobloomRenderState.moobloom;
        int overlay = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)moobloomRenderState, (float)0.0f);
        if (!moobloom.isBaby() && !moobloom.isInvisible()) {
            VegetationBlock flower = moobloom.getVariant().getFlower();
            BlockState blockState = flower.defaultBlockState();
            if (flower instanceof DoublePlantBlock) {
                blockState = (BlockState)blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
            }
            float scaleFactor = flower instanceof DoublePlantBlock ? 0.6f : 0.8f;
            float yOffset = flower instanceof DoublePlantBlock ? -0.666f : -0.5f;
            Minecraft minecraft = Minecraft.getInstance();
            boolean renderAsModel = minecraft.shouldEntityAppearGlowing((Entity)moobloom) && moobloom.isInvisible();
            BlockStateModel model = this.blockRenderer.getBlockModel(blockState);
            poseStack.pushPose();
            ((CowModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.translate(0.09, -0.6, -0.185);
            poseStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            poseStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(poseStack, submitNodeCollector, packedLight, renderAsModel, blockState, overlay, model);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.22, -0.28, -0.06);
            poseStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            poseStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(poseStack, submitNodeCollector, packedLight, renderAsModel, blockState, overlay, model);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(-0.2, -0.22, 0.01);
            poseStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            poseStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(poseStack, submitNodeCollector, packedLight, renderAsModel, blockState, overlay, model);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(0.03, -0.28, 0.47);
            poseStack.scale(-scaleFactor, -scaleFactor, scaleFactor);
            poseStack.translate(-0.5, (double)yOffset, -0.5);
            this.renderFlower(poseStack, submitNodeCollector, packedLight, renderAsModel, blockState, overlay, model);
            poseStack.popPose();
        }
    }

    private void renderFlower(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int light, boolean renderAsModel, BlockState blockState, int overlay, BlockStateModel model) {
        if (renderAsModel) {
            submitNodeCollector.submitBlockModel(poseStack, RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), model, 0.0f, 0.0f, 0.0f, light, overlay, 0);
        } else {
            submitNodeCollector.submitBlock(poseStack, blockState, light, overlay, 0);
        }
    }
}

