/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.feature;

import com.faboslav.friendsandfoes.common.client.render.entity.model.TuffGolemEntityModel;
import com.faboslav.friendsandfoes.common.client.render.entity.state.TuffGolemRenderState;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionfc;

public final class TuffGolemHeldItemFeatureRenderer
extends RenderLayer<TuffGolemRenderState, TuffGolemEntityModel> {
    private final ItemInHandRenderer heldItemRenderer;

    public TuffGolemHeldItemFeatureRenderer(RenderLayerParent<TuffGolemRenderState, TuffGolemEntityModel> renderer, ItemInHandRenderer heldItemRenderer) {
        super(renderer);
        this.heldItemRenderer = heldItemRenderer;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, TuffGolemRenderState renderState, float yRot, float xRot) {
        TuffGolemEntity tuffGolem = renderState.tuffGolem;
        float tickDelta = renderState.partialTick;
        float animationProgress = renderState.ageInTicks;
        if (tuffGolem.isDeadOrDying() || !tuffGolem.isHoldingItem()) {
            return;
        }
        ItemStack itemStack = tuffGolem.getItemBySlot(EquipmentSlot.MAINHAND);
        float yItemOffset = 0.4f;
        float levitationOffset = Mth.sin((float)(((float)tuffGolem.tickCount + tickDelta) / 10.0f + (float)Math.PI)) * 0.05f + 0.05f;
        float yOffset = levitationOffset + (1.0f - yItemOffset * 0.7f);
        float rotationAngle = (float)Math.toDegrees(animationProgress * 0.05f % ((float)Math.PI * 2));
        poseStack.pushPose();
        poseStack.translate(0.0, (double)yOffset, -0.575);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotationAngle));
        this.heldItemRenderer.renderItem((LivingEntity)tuffGolem, itemStack, ItemDisplayContext.GROUND, poseStack, submitNodeCollector, packedLight);
        poseStack.popPose();
    }
}

