/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerBurrowDownGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAroundGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerLookAtEntityGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerMeeleAttackGoal;
import com.faboslav.friendsandfoes.common.entity.ai.goal.mauler.MaulerWanderAroundFarGoal;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.MaulerAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityDataSerializers;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1621;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;

public final class MaulerEntity
extends class_1314
implements class_5354,
AnimatedEntity {
    private static final int HEALTH = 20;
    private static final float ANGERED_MOVEMENT_SPEED = 0.5f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float ATTACK_DAMAGE = 8.0f;
    private static final int MAXIMUM_STORED_EXPERIENCE_POINTS = 1395;
    public static final int MIN_TICKS_UNTIL_NEXT_BURROWING = 3000;
    public static final int MAX_TICKS_UNTIL_NEXT_BURROWING = 6000;
    private static final Type DEFAULT_TYPE = Type.DESERT;
    private static final String TYPE_NBT_NAME = "Type";
    private static final String STORED_EXPERIENCE_POINTS_NBT_NAME = "StoredExperiencePoints";
    private static final String IS_BURROWED_DOWN_NBT_NAME = "IsBurrowedDown";
    private static final String TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME = "TicksUntilNextBurrowingDown";
    private static final String BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME = "BurrowingDownAnimationProgress";
    private static final String BURROWED_DOWN_TICKS_NBT_NAME = "BurrowedDownTicks";
    private static final class_2940<String> TYPE;
    private static final class_2940<Integer> ANGER_TIME;
    private static final class_2940<Integer> STORED_EXPERIENCE_POINTS;
    private static final class_2940<Boolean> IS_MOVING;
    private static final class_2940<Boolean> IS_BURROWED_DOWN;
    private static final class_2940<Integer> TICKS_UNTIL_NEXT_BURROWING_DOWN;
    private static final class_2940<Float> BURROWING_DOWN_ANIMATION_PROGRESS;
    private static final class_2940<Integer> POSE_TICKS;
    private static final class_2940<FriendsAndFoesEntityPose> ENTITY_POSE;
    @Nullable
    private UUID angryAt;
    public MaulerBurrowDownGoal burrowDownGoal;
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
            this.animationContextTracker.add(MaulerAnimations.SNAP);
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return MaulerAnimations.TRACKED_ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        if (this.method_29511()) {
            return MaulerAnimations.WALK;
        }
        return MaulerAnimations.RUN;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        AnimationHolder animation = null;
        if (this.isInEntityPose(FriendsAndFoesEntityPose.IDLE) && !this.field_42108.method_48571()) {
            animation = MaulerAnimations.IDLE;
        }
        return animation;
    }

    public MaulerEntity(class_1299<? extends MaulerEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TYPE, (Object)DEFAULT_TYPE.name());
        builder.method_56912(ANGER_TIME, (Object)0);
        builder.method_56912(STORED_EXPERIENCE_POINTS, (Object)0);
        builder.method_56912(IS_MOVING, (Object)false);
        builder.method_56912(IS_BURROWED_DOWN, (Object)false);
        builder.method_56912(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)this.method_59922().method_39332(3000, 6000));
        builder.method_56912(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        builder.method_56912(POSE_TICKS, (Object)0);
        builder.method_56912(ENTITY_POSE, (Object)FriendsAndFoesEntityPose.IDLE);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        this.method_29517(nbt);
        nbt.method_71469(TYPE_NBT_NAME, this.getMaulerType().getName());
        nbt.method_71465(STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints());
        nbt.method_71472(IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown());
        nbt.method_71465(TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown());
        nbt.method_71464(BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress());
        if (this.burrowDownGoal != null && this.isBurrowedDown() && this.burrowDownGoal.getBurrowedDownTicks() > 0) {
            nbt.method_71465(BURROWED_DOWN_TICKS_NBT_NAME, this.burrowDownGoal.getBurrowedDownTicks());
        }
    }

    public void method_5749(class_11368 nbt) {
        int burrowedDownTicks;
        super.method_5749(nbt);
        this.method_29512(this.method_73183(), nbt);
        this.setType(Type.fromName(VersionedNbt.getString(nbt, TYPE_NBT_NAME, this.getMaulerType().getName())));
        this.setStoredExperiencePoints(VersionedNbt.getInt(nbt, STORED_EXPERIENCE_POINTS_NBT_NAME, this.getStoredExperiencePoints()));
        this.setBurrowedDown(VersionedNbt.getBoolean(nbt, IS_BURROWED_DOWN_NBT_NAME, this.isBurrowedDown()));
        this.setTicksUntilNextBurrowingDown(VersionedNbt.getInt(nbt, TICKS_UNTIL_NEXT_BURROWING_DOWN_NBT_NAME, this.getTicksUntilNextBurrowingDown()));
        this.setBurrowingDownAnimationProgress(VersionedNbt.getFloat(nbt, BURROWING_DOWN_ANIMATION_PROGRESS_NBT_NAME, this.getBurrowingDownAnimationProgress()));
        if (this.burrowDownGoal != null && this.isBurrowedDown() && (burrowedDownTicks = VersionedNbt.getInt(nbt, BURROWED_DOWN_TICKS_NBT_NAME, 0)) != 0) {
            this.burrowDownGoal.setBurrowedDownTicks(burrowedDownTicks);
            this.method_5684(true);
            this.method_5648(true);
        }
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_5321 biomeKey = world.method_23753(this.method_24515()).method_40230().orElse(class_1972.field_9449);
        Type type = Type.getTypeByBiome((class_5321<class_1959>)biomeKey);
        this.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        this.setType(type);
        this.setSize();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_16914();
    }

    public static boolean canSpawn(class_1299<MaulerEntity> maulerEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        return serverWorldAccess.method_8320(blockPos.method_10074()).method_26164(FriendsAndFoesTags.MAULERS_SPAWNABLE_ON);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new MaulerMeeleAttackGoal(this, 0.5, false));
        this.field_6201.method_6277(3, (class_1352)new MaulerWanderAroundFarGoal(this, 0.6));
        this.field_6201.method_6277(4, (class_1352)new MaulerLookAtEntityGoal((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(5, (class_1352)new MaulerLookAroundGoal(this));
        this.burrowDownGoal = new MaulerBurrowDownGoal(this);
        this.field_6201.method_6277(6, (class_1352)this.burrowDownGoal);
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1314.class, 10, true, true, (livingEntity, serverLevel) -> {
            class_1642 zombie;
            class_1621 slimeEntity;
            if (livingEntity instanceof class_1621 && (slimeEntity = (class_1621)livingEntity).method_7152() != 1 || livingEntity instanceof class_1642 && !(zombie = (class_1642)livingEntity).method_6109()) {
                return false;
            }
            return livingEntity.method_5864().method_20210(FriendsAndFoesTags.MAULER_PREY);
        }));
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableMauler) {
            this.method_31472();
        }
        this.setSize();
        super.method_5773();
        if (this.method_73183().method_8608()) {
            return;
        }
        if (this.getTicksUntilNextBurrowingDown() > 0) {
            this.setTicksUntilNextBurrowingDown(this.getTicksUntilNextBurrowingDown() - 1);
        }
        this.updateBurrowingDownAnimation();
    }

    public void method_6007() {
        if (!this.method_73183().method_8608() && this.getBurrowingDownAnimationProgress() > 0.0f) {
            this.method_5942().method_6344(0.0);
            this.method_5942().method_6340();
        }
        super.method_6007();
        if (this.method_73183().method_8608()) {
            return;
        }
        this.method_29510((class_3218)this.method_73183(), true);
        this.setMoving(this.method_5942().method_23966());
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        if (!this.method_73183().method_8608() && this.burrowDownGoal.isRunning()) {
            this.burrowDownGoal.method_6270();
        }
        return super.method_64397(level, damageSource, amount);
    }

    public float method_6029() {
        return this.method_29511() ? 0.5f : 0.3f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (!(this.method_29511() || itemStack.method_7960() || !itemStack.method_7942() && itemInHand != class_1802.field_8598)) {
            interactionResult = this.tryToInteractWithEnhancedItem(player, hand, itemStack);
        } else if (!this.method_29511() && itemInHand == class_1802.field_8469) {
            interactionResult = this.tryToInteractWithGlassBottle(player, itemStack);
        }
        if (interactionResult) {
            this.method_32875((class_6880)class_5712.field_28725, (class_1297)this);
            return VersionedInteractionResult.success((class_1297)this);
        }
        return super.method_5992(player, hand);
    }

    private boolean tryToInteractWithEnhancedItem(class_1657 player, class_1268 hand, class_1799 itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints >= 1395) {
            return false;
        }
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_5971();
            int experiencePoints = this.getExperiencePoints(itemStack);
            int recalculatedExperiencePoints = storedExperiencePoints + experiencePoints;
            if (recalculatedExperiencePoints > 1395) {
                recalculatedExperiencePoints = 1395;
            }
            this.setStoredExperiencePoints(recalculatedExperiencePoints);
            if (!player.method_31549().field_7477) {
                if (itemStack.method_7946()) {
                    itemStack.method_7934(1);
                } else {
                    class_1304 equipmentSlot = hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171;
                    player.method_5673(equipmentSlot, class_1799.field_8037);
                }
            }
            this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
            this.spawnParticles((class_2394)class_2398.field_11215, 7);
        }
        return true;
    }

    private boolean tryToInteractWithGlassBottle(class_1657 player, class_1799 itemStack) {
        int storedExperiencePoints = this.getStoredExperiencePoints();
        if (storedExperiencePoints < 7) {
            return false;
        }
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.method_5971();
            int glassBottlesCount = itemStack.method_7947();
            int experienceBottleCount = storedExperiencePoints / 7;
            if (experienceBottleCount > glassBottlesCount) {
                experienceBottleCount = glassBottlesCount;
            }
            itemStack.method_7934(experienceBottleCount);
            class_1799 experienceBottleItemStack = new class_1799((class_1935)class_1802.field_8287, experienceBottleCount);
            player.method_7270(experienceBottleItemStack);
            this.setStoredExperiencePoints(storedExperiencePoints - experienceBottleCount * 7);
            this.method_5783(class_3417.field_15029, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean method_27298() {
        return false;
    }

    public static class_5132.class_5133 createMaulerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_47760, 1.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 8.0);
    }

    public boolean method_5810() {
        return !this.isBurrowedDown() && super.method_5810();
    }

    public void method_6087(class_1297 entity) {
        if (this.isBurrowedDown()) {
            return;
        }
        super.method_6087(entity);
    }

    public void setEntityPose(FriendsAndFoesEntityPose pose) {
        if (this.method_73183().method_8608()) {
            return;
        }
        this.field_6011.method_12778(ENTITY_POSE, (Object)pose);
    }

    public FriendsAndFoesEntityPose getEntityPose() {
        return (FriendsAndFoesEntityPose)((Object)this.field_6011.method_12789(ENTITY_POSE));
    }

    public boolean isInEntityPose(FriendsAndFoesEntityPose pose) {
        return this.getEntityPose() == pose;
    }

    protected class_3414 method_5994() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_MAULER_GROWL.get();
    }

    public void method_5966() {
        if (this.method_29511() && this.isMoving() || this.isBurrowedDown()) {
            return;
        }
        this.method_5783(this.method_5994(), 0.5f, RandomGenerator.generateFloat(0.75f, 0.85f));
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_MAULER_HURT.get();
    }

    public void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.method_5783(this.method_6011(source), 0.5f, RandomGenerator.generateFloat(0.85f, 0.95f));
    }

    protected class_3414 method_6002() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_MAULER_DEATH.get();
    }

    public void method_5712(class_2338 pos, class_2680 state) {
        super.method_5712(pos, state);
        if (this.method_29511() && this.isMoving() && this.method_24828() && this.method_18798().method_10214() <= 1.0E-4) {
            this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_MAULER_BITE.get(), 0.2f, RandomGenerator.generateFloat(0.9f, 0.95f));
        }
    }

    public boolean method_6121(class_3218 level, class_1297 target) {
        if (this.isBurrowedDown()) {
            return false;
        }
        return VersionedEntity.hurt(target, this.method_48923().method_48812((class_1309)this), (float)this.method_45325(class_5134.field_23721));
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int angerTime) {
        this.field_6011.method_12778(ANGER_TIME, (Object)angerTime);
    }

    public void method_29509() {
        int angerTime = this.method_59922().method_39332(400, 1000);
        this.method_29514(angerTime);
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public Type getMaulerType() {
        return Type.fromName((String)this.field_6011.method_12789(TYPE));
    }

    private void setType(Type type) {
        this.field_6011.method_12778(TYPE, (Object)type.name);
    }

    public int getStoredExperiencePoints() {
        return (Integer)this.field_6011.method_12789(STORED_EXPERIENCE_POINTS);
    }

    public void setStoredExperiencePoints(int storedExperiencePoints) {
        this.field_6011.method_12778(STORED_EXPERIENCE_POINTS, (Object)storedExperiencePoints);
        this.field_6194 = storedExperiencePoints;
    }

    public void setSize() {
        float size = this.getSize();
        this.method_5996(class_5134.field_47760).method_6192((double)this.getSize());
        this.method_5996(class_5134.field_23716).method_6192((double)((int)(20.0f * size)));
        this.method_5996(class_5134.field_23721).method_6192((double)(8.0f * (size / 2.0f)));
        this.method_18382();
        this.method_33332();
    }

    public float getSize() {
        return 1.0f + (float)this.getStoredExperiencePoints() / 1395.0f * 1.25f;
    }

    public float method_17825() {
        return this.getSize();
    }

    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(IS_MOVING);
    }

    public void setMoving(boolean isMoving) {
        this.field_6011.method_12778(IS_MOVING, (Object)isMoving);
    }

    public boolean isBurrowedDown() {
        return (Boolean)this.field_6011.method_12789(IS_BURROWED_DOWN);
    }

    public void setBurrowedDown(boolean isBurrowedDown) {
        this.field_6011.method_12778(IS_BURROWED_DOWN, (Object)isBurrowedDown);
    }

    public int getTicksUntilNextBurrowingDown() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_NEXT_BURROWING_DOWN);
    }

    public void setTicksUntilNextBurrowingDown(int ticksUntilNextBurrowingDown) {
        this.field_6011.method_12778(TICKS_UNTIL_NEXT_BURROWING_DOWN, (Object)ticksUntilNextBurrowingDown);
    }

    public float getBurrowingDownAnimationProgress() {
        return ((Float)this.field_6011.method_12789(BURROWING_DOWN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setBurrowingDownAnimationProgress(float burrowingDownAnimationProgress) {
        this.field_6011.method_12778(BURROWING_DOWN_ANIMATION_PROGRESS, (Object)Float.valueOf(burrowingDownAnimationProgress));
    }

    private void updateBurrowingDownAnimation() {
        if (this.isBurrowedDown()) {
            this.setBurrowingDownAnimationProgress(Math.min(1.0f, this.getBurrowingDownAnimationProgress() + 0.04f));
        } else {
            this.setBurrowingDownAnimationProgress(Math.max(0.0f, this.getBurrowingDownAnimationProgress() - 0.04f));
        }
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.6f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    private int getExperiencePoints(class_1799 stack) {
        int i = 0;
        class_9304 itemEnchantmentsComponent = class_1890.method_57532((class_1799)stack);
        for (Object2IntMap.Entry entry : itemEnchantmentsComponent.method_57539()) {
            class_6880 registryEntry = (class_6880)entry.getKey();
            int j = entry.getIntValue();
            if (registryEntry.method_40220(class_9636.field_51551)) continue;
            i += ((class_1887)registryEntry.comp_349()).method_8182(j);
        }
        return i;
    }

    public void spawnParticles(class_2394 particleEffect, int amount) {
        class_1937 world = this.method_73183();
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)world).method_65096(particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, this.method_59922().method_43059() * 0.02, this.method_59922().method_43059() * 0.02, this.method_59922().method_43059() * 0.02, 1.0);
        }
    }

    static {
        ENTITY_POSE = class_2945.method_12791(MaulerEntity.class, FriendsAndFoesEntityDataSerializers.ENTITY_POSE);
        TYPE = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13326);
        ANGER_TIME = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13327);
        STORED_EXPERIENCE_POINTS = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13327);
        IS_MOVING = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13323);
        IS_BURROWED_DOWN = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13323);
        TICKS_UNTIL_NEXT_BURROWING_DOWN = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13327);
        BURROWING_DOWN_ANIMATION_PROGRESS = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13320);
        POSE_TICKS = class_2945.method_12791(MaulerEntity.class, (class_2941)class_2943.field_13327);
    }

    public static enum Type {
        BADLANDS("badlands"),
        DESERT("desert"),
        SAVANNA("savanna");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private static Type fromName(String name) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return SAVANNA;
        }

        public static Type getTypeByBiome(class_5321<class_1959> biome) {
            if (biome == class_1972.field_9424) {
                return DESERT;
            }
            if (biome == class_1972.field_9415 || biome == class_1972.field_9443 || biome == class_1972.field_35110) {
                return BADLANDS;
            }
            return SAVANNA;
        }
    }
}

