/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.versions.VersionedGameRulesProvider;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_5803;

public final class GlareShakeGlowBerriesTask
extends class_4097<GlareEntity> {
    private static final int MAX_SHAKING_TICKS = 200;
    private static final float WITHING_DISTANCE = 2.0f;
    private int shakingTicks;

    public GlareShakeGlowBerriesTask() {
        super(Map.of((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get(), class_4141.field_18456), 200);
    }

    protected boolean checkExtraStartConditions(class_3218 world, GlareEntity glare) {
        class_4208 glowBerriesPos = glare.getGlowBerriesPos();
        return VersionedGameRulesProvider.getGameRules((class_1297)glare).method_8355(class_1928.field_19388) && FriendsAndFoes.getConfig().enableGlareGriefing && !glare.method_60953() && !glare.method_24345() && glare.method_6118(class_1304.field_6173).method_7960() && glowBerriesPos != null && glare.canEatGlowBerriesAt(glowBerriesPos.comp_2208()) && glowBerriesPos.comp_2208().method_19769((class_2374)glare.method_73189(), 2.0);
    }

    protected void start(class_3218 world, GlareEntity glare, long time) {
        this.shakingTicks = 0;
    }

    protected boolean canStillUse(class_3218 world, GlareEntity glare, long time) {
        class_4208 glowBerriesPos = glare.getGlowBerriesPos();
        return VersionedGameRulesProvider.getGameRules((class_1297)glare).method_8355(class_1928.field_19388) && FriendsAndFoes.getConfig().enableGlareGriefing && !glare.method_60953() && !glare.method_24345() && glare.method_6118(class_1304.field_6173).method_7960() && glowBerriesPos != null && glare.canEatGlowBerriesAt(glowBerriesPos.comp_2208()) && glowBerriesPos.comp_2208().method_19769((class_2374)glare.method_73189(), 2.0);
    }

    protected void tick(class_3218 world, GlareEntity glare, long time) {
        ++this.shakingTicks;
        if (this.shakingTicks % 5 == 0 && (double)glare.method_59922().method_43057() > 0.85) {
            glare.playRustleSound();
        }
        if (glare.method_59922().method_43057() < 0.05f && this.shakingTicks > 100) {
            glare.method_5966();
            this.shakeOffGlowBerries(glare);
            GlareBrain.setLocatingGlowBerriesCooldown(glare);
        }
    }

    protected void stop(class_3218 world, GlareEntity glare, long time) {
        glare.method_18868().method_18875((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get());
    }

    private void shakeOffGlowBerries(GlareEntity glare) {
        if (!VersionedGameRulesProvider.getGameRules((class_1297)glare).method_8355(class_1928.field_19388) || !FriendsAndFoes.getConfig().enableGlareGriefing) {
            return;
        }
        class_4208 glowBerriesPos = glare.getGlowBerriesPos();
        if (glowBerriesPos == null) {
            return;
        }
        class_2680 blockState = glare.method_73183().method_8320(glowBerriesPos.comp_2208());
        if (!class_5803.method_33618((class_2680)blockState)) {
            return;
        }
        class_5803.method_33619((class_1297)glare, (class_2680)blockState, (class_1937)glare.method_73183(), (class_2338)glowBerriesPos.comp_2208());
    }
}

