/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.renderer;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.client.render.entity.model.CrabEntityModel;
import com.faboslav.friendsandfoes.common.client.render.entity.state.CrabRenderState;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityModelLayers;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrabEntityRenderer
extends AgeableMobRenderer<CrabEntity, CrabRenderState, CrabEntityModel> {
    private static final ResourceLocation TEXTURE = FriendsAndFoes.makeID("textures/entity/crab/crab.png");

    public CrabEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CrabEntityModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.CRAB_LAYER)), (EntityModel)new CrabEntityModel(context.bakeLayer(FriendsAndFoesEntityModelLayers.CRAB_BABY_LAYER)), 0.5f);
    }

    protected float getShadowRadius(CrabRenderState renderState) {
        CrabEntity crab = renderState.crab;
        float shadowRadius = super.getShadowRadius((LivingEntityRenderState)renderState);
        boolean isBaby = crab.isBaby();
        shadowRadius *= crab.getSize().getScaleModifier();
        if (isBaby) {
            shadowRadius *= 0.5f;
        }
        return shadowRadius;
    }

    public CrabRenderState createRenderState() {
        return new CrabRenderState();
    }

    public void extractRenderState(CrabEntity crab, CrabRenderState renderState, float partialTick) {
        super.extractRenderState((LivingEntity)crab, (LivingEntityRenderState)renderState, partialTick);
        renderState.crab = crab;
    }

    public ResourceLocation getTextureLocation(CrabRenderState renderState) {
        return TEXTURE;
    }
}

