/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import net.minecraft.class_10275;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1380;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1617;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class IllusionerEntity
extends class_1617
implements class_1603 {
    private static final int MAX_ILLUSIONS_COUNT = FriendsAndFoes.getConfig().illusionerMaxIllusionsCount;
    private static final int ILLUSION_LIFETIME_TICKS = FriendsAndFoes.getConfig().illusionerIllusionLifetimeTicks;
    private static final int INVISIBILITY_TICKS = FriendsAndFoes.getConfig().illusionerInvisibilityTicks;
    private static final String IS_ILLUSION_NBT_NAME = "IsIllusion";
    private static final String WAS_ATTACKED_NBT_NAME = "WasAttacked";
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final String TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME = "TicksUntilCanCreateIllusions";
    private IllusionerEntity illusioner;
    private boolean isIllusion;
    private boolean wasAttacked;
    private int ticksUntilDespawn;
    private int ticksUntilCanCreateIllusion;

    public IllusionerEntity(class_1299<? extends IllusionerEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 5;
        this.illusioner = null;
        this.isIllusion = false;
        this.wasAttacked = false;
        this.ticksUntilDespawn = 0;
        this.ticksUntilCanCreateIllusion = 0;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1617.class_1619((class_1617)this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_10275.class, 8.0f, 1.0, 1.2));
        this.field_6201.method_6277(5, (class_1352)new IllusionerBlindnessSpellGoal());
        this.field_6201.method_6277(6, (class_1352)new class_1380((class_1588)this, 0.5, 20, 15.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, PlayerIllusionEntity.class, true).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_3988.class, false).method_6330(300));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1439.class, false).method_6330(300));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556(IS_ILLUSION_NBT_NAME, this.isIllusion());
        nbt.method_10556(WAS_ATTACKED_NBT_NAME, this.wasAttacked());
        nbt.method_10569(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.method_10569(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, this.getTicksUntilCanCreateIllusions());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setIsIllusion(VersionedNbt.getBoolean(nbt, IS_ILLUSION_NBT_NAME, false));
        this.setWasAttacked(VersionedNbt.getBoolean(nbt, WAS_ATTACKED_NBT_NAME, false));
        this.setTicksUntilDespawn(VersionedNbt.getInt(nbt, TICKS_UNTIL_DESPAWN_NBT_NAME, 0));
        this.setTicksUntilCanCreateIllusions(VersionedNbt.getInt(nbt, TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, 0));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 18.0).method_26868(class_5134.field_23716, 24.0);
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        return super.method_5943(level, difficulty, spawnReason, entityData);
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            this.method_31472();
        }
        super.method_5773();
    }

    public void method_6007() {
        boolean isIllusionerNonExistingOrDead;
        super.method_6007();
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.getTicksUntilCanCreateIllusions() > 0) {
            this.setTicksUntilCanCreateIllusions(this.getTicksUntilCanCreateIllusions() - 1);
        }
        if (this.wasAttacked() && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        if (this.wasAttacked() && this.method_5968() == null && this.getTicksUntilCanCreateIllusions() < ILLUSION_LIFETIME_TICKS / 3) {
            this.setWasAttacked(false);
            this.setTicksUntilCanCreateIllusions(0);
        }
        if (!this.isIllusion()) {
            return;
        }
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isIllusionerNonExistingOrDead = this.getIllusioner() != null && !this.getIllusioner().method_5805();
        if (this.getTicksUntilDespawn() == 0 || isIllusionerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        block6: {
            block7: {
                class_1297 attacker = damageSource.method_5529();
                class_1299 attackerType = null;
                if (attacker != null) {
                    attackerType = attacker.method_5864();
                }
                if (attackerType != null && (attackerType.method_20210(class_3483.field_48293) || attackerType.method_20210(class_3483.field_19168)) || this.isIllusion() && !(attacker instanceof class_1309)) {
                    return false;
                }
                if (this.method_37908().method_8608() || attackerType == null || attackerType.method_20210(class_3483.field_48293) || attackerType.method_20210(class_3483.field_19168)) break block6;
                if (this.isIllusion()) {
                    this.discardIllusion();
                    return false;
                }
                if (this.getTicksUntilCanCreateIllusions() != 0 || attackerType.method_20210(class_3483.field_48293) || attackerType.method_20210(class_3483.field_19168)) break block6;
                class_1297 class_12972 = damageSource.method_5529();
                if (!(class_12972 instanceof class_1657)) break block7;
                class_1657 player = (class_1657)class_12972;
                if (player.method_31549().field_7477) break block6;
            }
            this.createIllusions();
        }
        return super.method_64397(level, damageSource, amount);
    }

    public class_3414 method_20033() {
        return class_3417.field_14644;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14644;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15153;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15223;
    }

    protected class_3414 method_7142() {
        return class_3417.field_14545;
    }

    public void method_16484(class_3218 level, int wave, boolean unused) {
    }

    public void method_7105(class_1309 target, float velocity) {
        class_1799 itemStack = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
        class_1799 itemStack2 = this.method_18808(itemStack);
        class_1665 abstractArrow = class_1675.method_18813((class_1309)this, (class_1799)itemStack2, (float)velocity, (class_1799)itemStack);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - abstractArrow.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f);
        class_1937 var15 = this.method_37908();
        if (var15 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)var15;
            class_1676.method_61552((class_1676)abstractArrow, (class_3218)serverLevel, (class_1799)itemStack2, (double)d, (double)(e + g * (double)0.2f), (double)f, (float)1.6f, (float)(14 - serverLevel.method_8407().method_5461() * 4));
        }
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
    }

    public class_1543.class_1544 method_6990() {
        if (this.method_7137()) {
            return class_1543.class_1544.field_7212;
        }
        return this.method_6510() ? class_1543.class_1544.field_7208 : class_1543.class_1544.field_7207;
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.method_31472();
    }

    private void createIllusions() {
        this.setWasAttacked(true);
        this.setTicksUntilCanCreateIllusions(ILLUSION_LIFETIME_TICKS);
        this.playMirrorSound();
        this.method_6092(new class_1293(class_1294.field_5905, INVISIBILITY_TICKS));
        this.spawnCloudParticles();
        if (MAX_ILLUSIONS_COUNT == 0) {
            return;
        }
        class_243 illusionerPosition = this.method_19538();
        float slice = (float)Math.PI * 2 / (float)MAX_ILLUSIONS_COUNT;
        int radius = 9;
        int randomPoint = this.method_59922().method_39332(0, MAX_ILLUSIONS_COUNT - 1);
        for (int point = 0; point < MAX_ILLUSIONS_COUNT; ++point) {
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.method_10216() + (double)((float)radius * class_3532.method_15362((float)angle)));
            int y = (int)illusionerPosition.method_10214();
            int z = (int)(illusionerPosition.method_10215() + (double)((float)radius * class_3532.method_15374((float)angle)));
            if (randomPoint == point) {
                this.tryToTeleport(x, y, z);
                continue;
            }
            this.createIllusion(x, y, z);
        }
    }

    private void createIllusion(int x, int y, int z) {
        IllusionerEntity illusioner = this;
        IllusionerEntity illusion = (IllusionerEntity)((class_1299)FriendsAndFoesEntityTypes.ILLUSIONER.get()).method_5883(this.method_37908(), class_3730.field_16471);
        illusion.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        illusion.setIsIllusion(true);
        illusion.setIllusioner(illusioner);
        illusion.setTicksUntilDespawn(ILLUSION_LIFETIME_TICKS);
        illusion.method_6033(this.method_6063());
        illusion.method_5719((class_1297)illusioner);
        boolean teleportResult = this.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.method_37908().method_8649((class_1297)illusion);
            this.spawnCloudParticles();
        }
    }

    public boolean tryToTeleport(int x, int y, int z) {
        int worldBottomY = this.method_37908().method_31607();
        double bottomY = Math.max(y -= 8, worldBottomY);
        double topY = Math.min(bottomY + 16.0, (double)(((class_3218)this.method_37908()).method_32819() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.method_6082(x, y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void playMirrorSound() {
        this.method_5783(class_3417.field_14941, this.method_6107(), this.method_6017());
    }

    public void spawnCloudParticles() {
        this.spawnParticles(class_2398.field_11204, 16);
    }

    private <T extends class_2394> void spawnParticles(T particleType, int amount) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.method_37908()).method_65096(particleType, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isIllusion() {
        return this.isIllusion;
    }

    public void setIsIllusion(boolean isIllusion) {
        this.isIllusion = isIllusion;
    }

    public boolean wasAttacked() {
        return this.wasAttacked;
    }

    public void setWasAttacked(boolean wasAttacked) {
        this.wasAttacked = wasAttacked;
    }

    @Nullable
    public IllusionerEntity getIllusioner() {
        return this.illusioner;
    }

    public void setIllusioner(IllusionerEntity illusioner) {
        this.illusioner = illusioner;
    }

    public int getTicksUntilDespawn() {
        return this.ticksUntilDespawn;
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.ticksUntilDespawn = ticksUntilDespawn;
    }

    public int getTicksUntilCanCreateIllusions() {
        return this.ticksUntilCanCreateIllusion;
    }

    public void setTicksUntilCanCreateIllusions(int ticksUntilCanCreateIllusions) {
        this.ticksUntilCanCreateIllusion = ticksUntilCanCreateIllusions;
    }

    public class IllusionerBlindnessSpellGoal
    extends class_1617.class_1620 {
        private int lastTargetId;

        IllusionerBlindnessSpellGoal() {
            super((class_1617)IllusionerEntity.this);
        }

        public boolean method_6264() {
            if (!super.method_6264()) {
                return false;
            }
            if (IllusionerEntity.this.method_5968() == null) {
                return false;
            }
            if (IllusionerEntity.this.method_5968().method_5628() == this.lastTargetId) {
                return false;
            }
            return IllusionerEntity.this.method_37908().method_8404(IllusionerEntity.this.method_24515()).method_5455((float)class_1267.field_5802.ordinal());
        }

        public void method_6269() {
            super.method_6269();
            class_1309 livingEntity = IllusionerEntity.this.method_5968();
            if (livingEntity != null) {
                this.lastTargetId = livingEntity.method_5628();
            }
        }

        protected int method_7149() {
            return 20;
        }

        protected int method_7151() {
            return 180;
        }

        protected void method_7148() {
            IllusionerEntity.this.method_5968().method_37222(new class_1293(class_1294.field_5919, 200), (class_1297)IllusionerEntity.this);
        }

        protected class_3414 method_7150() {
            return class_3417.field_15019;
        }

        protected class_1617.class_1618 method_7147() {
            return class_1617.class_1618.field_7378;
        }
    }
}

