/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public final class CopperGolemSpinHeadTask
extends class_4097<CopperGolemEntity> {
    private int spinHeadTicks = 0;
    private int maxSpinHeadTicks = 0;

    public CopperGolemSpinHeadTask() {
        super(Map.of((class_4140)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_SPIN_HEAD_COOLDOWN.get(), class_4141.field_18457, (class_4140)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), class_4141.field_18457), 40);
    }

    protected boolean checkExtraStartConditions(class_3218 world, CopperGolemEntity copperGolem) {
        return !((double)copperGolem.method_59922().method_43057() < 0.9);
    }

    protected void start(class_3218 world, CopperGolemEntity copperGolem, long time) {
        this.spinHeadTicks = 0;
        this.maxSpinHeadTicks = CopperGolemAnimations.SPIN_HEAD.get().lengthInTicks(copperGolem.getAnimationSpeedModifier());
        copperGolem.startSpinHeadAnimation();
    }

    protected boolean canStillUse(class_3218 world, CopperGolemEntity copperGolem, long time) {
        return this.spinHeadTicks <= this.maxSpinHeadTicks && !copperGolem.isOxidized();
    }

    protected void tick(class_3218 world, CopperGolemEntity copperGolem, long time) {
        ++this.spinHeadTicks;
    }

    protected void stop(class_3218 world, CopperGolemEntity copperGolem, long time) {
        copperGolem.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        CopperGolemBrain.setSpinHeadCooldown(copperGolem);
    }
}

