/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.api;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class MoobloomVariantManager
extends SimpleJsonResourceReloadListener<MoobloomVariant> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final MoobloomVariant DEFAULT_MOOBLOOM_VARIANT = new MoobloomVariant("buttercup", (Block)FriendsAndFoesBlocks.BUTTERCUP.get(), FriendsAndFoesTags.HAS_MOOBLOOMS);
    public static final MoobloomVariantManager MOOBLOOM_VARIANT_MANAGER = new MoobloomVariantManager();
    private List<MoobloomVariant> moobloomVariants = new ArrayList<MoobloomVariant>(){
        {
            this.add(DEFAULT_MOOBLOOM_VARIANT);
        }
    };

    private MoobloomVariantManager() {
        super(MoobloomVariant.CODEC, FileToIdConverter.json((String)"moobloom_variants"));
    }

    protected void apply(Map<ResourceLocation, MoobloomVariant> moobloomVariants, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.apply(moobloomVariants);
    }

    public void apply(Map<ResourceLocation, MoobloomVariant> moobloomVariants) {
        this.moobloomVariants.clear();
        this.moobloomVariants.add(DEFAULT_MOOBLOOM_VARIANT);
        for (Map.Entry<ResourceLocation, MoobloomVariant> entry : moobloomVariants.entrySet()) {
            MoobloomVariant moobloomVariant = entry.getValue();
            this.moobloomVariants.add(new MoobloomVariant(moobloomVariant.getName(), (Block)moobloomVariant.getFlower(), moobloomVariant.getBiomes()));
        }
        FriendsAndFoes.getLogger().info("Loaded {} moobloom variants", (Object)this.moobloomVariants.size());
    }

    public void setMoobloomVariants(List<MoobloomVariant> moobloomVariants) {
        this.moobloomVariants = moobloomVariants;
    }

    public List<MoobloomVariant> getMoobloomVariants() {
        return this.moobloomVariants;
    }

    public MoobloomVariant getDefaultMoobloomVariant() {
        return DEFAULT_MOOBLOOM_VARIANT;
    }

    public MoobloomVariant getRandomMoobloomVariant(RandomSource random) {
        Object[] values = this.getMoobloomVariants().toArray();
        int min = 0;
        int max = values.length - 1;
        return (MoobloomVariant)values[random.nextInt(max - min + 1) + min];
    }

    @Nullable
    public MoobloomVariant getMoobloomVariantByName(String name) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!Objects.equals(moobloomVariant.getName(), name)) continue;
            return moobloomVariant;
        }
        return null;
    }

    @Nullable
    public MoobloomVariant getRandomBiomeSpecificMoobloomVariant(ServerLevelAccessor serverWorldAccess, BlockPos blockPos) {
        ArrayList<MoobloomVariant> possibleMoobloomVariants = new ArrayList<MoobloomVariant>();
        Holder biome = serverWorldAccess.getBiome(blockPos);
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!biome.is(moobloomVariant.getBiomes())) continue;
            possibleMoobloomVariants.add(moobloomVariant);
        }
        if (possibleMoobloomVariants.isEmpty()) {
            return null;
        }
        return (MoobloomVariant)possibleMoobloomVariants.get(serverWorldAccess.getRandom().nextInt(possibleMoobloomVariants.size()));
    }

    @Nullable
    public MoobloomVariant getByFlowerItem(Item flowerItem) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (moobloomVariant.getFlowerAsItem() != flowerItem) continue;
            return moobloomVariant;
        }
        return null;
    }
}

