/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CopperGolemLocateButtonTask
extends Behavior<CopperGolemEntity> {
    public CopperGolemLocateButtonTask() {
        super(Map.of((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_PRESS_BUTTON_COOLDOWN.get(), MemoryStatus.VALUE_ABSENT, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), MemoryStatus.VALUE_ABSENT, (MemoryModuleType)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), MemoryStatus.VALUE_ABSENT));
    }

    protected void start(ServerLevel world, CopperGolemEntity copperGolem, long time) {
        BlockPos buttonBlockPos = this.findNearestRandomButton(copperGolem);
        if (buttonBlockPos == null) {
            CopperGolemBrain.setPressButtonCooldown(copperGolem, TimeUtil.rangeOfSeconds((int)10, (int)10));
            return;
        }
        ResourceKey registryKey = copperGolem.level().dimension();
        copperGolem.getBrain().setMemory((MemoryModuleType)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), (Object)GlobalPos.of((ResourceKey)registryKey, (BlockPos)buttonBlockPos));
    }

    private BlockPos findNearestRandomButton(CopperGolemEntity copperGolem) {
        int horizontalRange = 16;
        int verticalRange = 8;
        List<BlockPos> buttons = this.findAllButtonsInRange(copperGolem.blockPosition(), horizontalRange, verticalRange, blockPos -> copperGolem.level().getBlockState(blockPos).is(FriendsAndFoesTags.COPPER_BUTTONS));
        if (buttons.isEmpty()) {
            return null;
        }
        return buttons.get(copperGolem.getRandom().nextInt(buttons.size()));
    }

    private List<BlockPos> findAllButtonsInRange(BlockPos copperGolemPos, int horizontalRange, int verticalRange, Predicate<BlockPos> condition) {
        ArrayList<BlockPos> buttons = new ArrayList<BlockPos>();
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)copperGolemPos, (int)horizontalRange, (int)verticalRange, (int)horizontalRange)) {
            BlockPos.MutableBlockPos possibleButtonBlockPos = blockPos.mutable();
            if (!condition.test((BlockPos)possibleButtonBlockPos)) continue;
            buttons.add((BlockPos)possibleButtonBlockPos);
        }
        return buttons;
    }
}

