/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain;

import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalFindInteractionTargetTask;
import com.faboslav.friendsandfoes.common.entity.ai.brain.task.rascal.RascalWaitForPlayerTask;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesActivities;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4121;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4802;
import net.minecraft.class_4818;
import net.minecraft.class_5753;
import net.minecraft.class_6019;

public final class RascalBrain {
    public static final List<class_4140<?>> MEMORY_MODULES;
    public static final List<class_4149<? extends class_4148<? super RascalEntity>>> SENSORS;
    public static final int NOD_COOLDOWN = 10;
    private static final class_6019 NOD_COOLDOWN_PROVIDER;
    private static final class_6019 AVOID_MEMORY_DURATION;

    public static class_4095<?> create(Dynamic<?> dynamic) {
        class_4095.class_5303 profile = class_4095.method_28311(MEMORY_MODULES, SENSORS);
        class_4095 brain = profile.method_28335(dynamic);
        RascalBrain.addCoreActivities((class_4095<RascalEntity>)brain);
        RascalBrain.addIdleActivities((class_4095<RascalEntity>)brain);
        RascalBrain.addWaitActivities((class_4095<RascalEntity>)brain);
        RascalBrain.addAvoidActivities((class_4095<RascalEntity>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<RascalEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753((class_4140)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get())));
    }

    private static void addIdleActivities(class_4095<RascalEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, RascalFindInteractionTargetTask.create(6)), (Object)Pair.of((Object)0, RascalBrain.makeRandomWanderTask())));
    }

    private static void addWaitActivities(class_4095<RascalEntity> brain) {
        brain.method_24527((class_4168)FriendsAndFoesActivities.RASCAL_WAIT.get(), 10, ImmutableList.of((Object)((Object)new RascalWaitForPlayerTask())), class_4140.field_18447);
    }

    private static void addAvoidActivities(class_4095<RascalEntity> brain) {
        brain.method_24527(class_4168.field_22399, 10, ImmutableList.of((Object)class_4121.method_24603((class_4140)class_4140.field_22357, (float)1.0f, (int)32, (boolean)true)), class_4140.field_22357);
    }

    public static void updateActivities(RascalEntity rascal) {
        rascal.method_18868().method_24531((List)ImmutableList.of((Object)((class_4168)FriendsAndFoesActivities.RASCAL_WAIT.get()), (Object)class_4168.field_22399, (Object)class_4168.field_18595));
    }

    private static class_4118<RascalEntity> makeRandomWanderTask() {
        return new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47014((float)0.6f), (Object)2), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1)));
    }

    public static void setNodCooldown(RascalEntity rascal) {
        rascal.method_18868().method_18878((class_4140)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)NOD_COOLDOWN_PROVIDER.method_35008(rascal.method_59922()));
        RascalBrain.onCooldown(rascal);
    }

    public static boolean shouldRunAway(RascalEntity rascal) {
        return rascal.method_18868().method_46873((class_4140)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get()).isPresent();
    }

    public static void onCooldown(RascalEntity rascal) {
        if (!RascalBrain.shouldRunAway(rascal)) {
            return;
        }
        if (rascal.method_16914()) {
            return;
        }
        class_1309 nearestTarget = rascal.method_18868().method_46873(class_4140.field_18447).orElse(null);
        if (nearestTarget == null) {
            return;
        }
        RascalBrain.runAwayFrom(rascal, nearestTarget);
    }

    private static void runAwayFrom(RascalEntity rascal, class_1309 target) {
        rascal.method_18868().method_18875(class_4140.field_18446);
        rascal.method_18868().method_18875(class_4140.field_18445);
        rascal.method_18868().method_18875(class_4140.field_18447);
        rascal.method_18868().method_24525(class_4140.field_22357, (Object)target, (long)AVOID_MEMORY_DURATION.method_35008(rascal.method_59922()));
    }

    static {
        SENSORS = List.of(class_4149.field_18466, class_4149.field_18467);
        MEMORY_MODULES = List.of(class_4140.field_18442, class_4140.field_18449, class_4140.field_18446, class_4140.field_18445, class_4140.field_22357, class_4140.field_18447, class_4140.field_22354, class_4140.field_18443, class_4140.field_19293, (class_4140)FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get());
        NOD_COOLDOWN_PROVIDER = class_4802.method_24505((int)10, (int)10);
        AVOID_MEMORY_DURATION = class_4802.method_24505((int)10, (int)10);
    }
}

