/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.coppergolem;

import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.CopperGolemBrain;
import com.faboslav.friendsandfoes.common.entity.animation.CopperGolemAnimations;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_5712;
import net.minecraft.class_5955;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemPressButtonTask
extends class_4097<CopperGolemEntity> {
    private static final float WITHING_DISTANCE = 2.0f;
    private int pressButtonTicks = 0;
    private int minPressButtonTick = 0;
    private int maxPressButtonTicks = 0;
    private boolean wasButtonPressed = false;
    private int heightDifference = 0;

    public CopperGolemPressButtonTask() {
        super(Map.of((class_4140)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get(), class_4141.field_18456, (class_4140)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_IS_OXIDIZED.get(), class_4141.field_18457), 100);
    }

    protected boolean checkExtraStartConditions(class_3218 world, CopperGolemEntity copperGolem) {
        return copperGolem.getButtonPos() != null && copperGolem.isButtonValidToBePressed(copperGolem.getButtonPos().comp_2208()) && copperGolem.getButtonPos().comp_2208().method_19769((class_2374)copperGolem.method_19538(), 2.0) && !copperGolem.method_5942().method_23966();
    }

    protected void start(class_3218 world, CopperGolemEntity copperGolem, long time) {
        this.pressButtonTicks = 0;
        this.wasButtonPressed = false;
        class_4208 buttonPos = copperGolem.getButtonPos();
        if (buttonPos == null) {
            return;
        }
        this.heightDifference = buttonPos.comp_2208().method_10264() - copperGolem.method_24515().method_10264();
        this.maxPressButtonTicks = this.heightDifference >= 1 ? CopperGolemAnimations.PRESS_BUTTON_UP.get().lengthInTicks(copperGolem.getAnimationSpeedModifier()) : CopperGolemAnimations.PRESS_BUTTON_DOWN.get().lengthInTicks(copperGolem.getAnimationSpeedModifier());
        this.minPressButtonTick = copperGolem.method_59922().method_39332((int)((double)this.maxPressButtonTicks * 0.4), (int)((double)this.maxPressButtonTicks * 0.6));
    }

    protected boolean canStillUse(class_3218 world, CopperGolemEntity copperGolem, long time) {
        return this.pressButtonTicks <= this.maxPressButtonTicks && !copperGolem.isOxidized();
    }

    protected void tick(class_3218 world, CopperGolemEntity copperGolem, long time) {
        ++this.pressButtonTicks;
        if (this.heightDifference >= 1) {
            copperGolem.startPressButtonUpAnimation();
        } else {
            copperGolem.startPressButtonDownAnimation();
        }
        if (!copperGolem.isWaxed() && copperGolem.getOxidationLevel().ordinal() >= class_5955.class_5811.field_28706.ordinal() && (double)copperGolem.method_59922().method_43057() > 0.99) {
            copperGolem.setOxidationLevel(class_5955.class_5811.field_28707);
        }
        if (this.pressButtonTicks < this.minPressButtonTick) {
            return;
        }
        if (this.wasButtonPressed) {
            return;
        }
        class_4208 buttonPos = copperGolem.getButtonPos();
        if (buttonPos == null) {
            return;
        }
        this.wasButtonPressed = this.tryToPressButton(copperGolem, buttonPos.comp_2208());
    }

    protected void stop(class_3218 world, CopperGolemEntity copperGolem, long time) {
        copperGolem.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        copperGolem.method_18868().method_18875((class_4140)FriendsAndFoesMemoryModuleTypes.COPPER_GOLEM_BUTTON_POS.get());
        CopperGolemBrain.setPressButtonCooldown(copperGolem);
    }

    private boolean tryToPressButton(CopperGolemEntity copperGolem, class_2338 buttonPos) {
        class_2680 buttonBlockState = this.getButtonBlockState(copperGolem, buttonPos);
        if (buttonBlockState == null || ((Boolean)buttonBlockState.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
            return false;
        }
        class_2269 buttonBlock = (class_2269)buttonBlockState.method_26204();
        buttonBlock.method_21845(buttonBlockState, copperGolem.method_37908(), buttonPos, null);
        copperGolem.method_37908().method_8396(null, buttonPos, buttonBlock.method_9712(true), class_3419.field_15245, 0.3f, 0.6f);
        copperGolem.method_37908().method_33596((class_1297)copperGolem, (class_6880)class_5712.field_28174, buttonPos);
        return true;
    }

    @Nullable
    private class_2680 getButtonBlockState(CopperGolemEntity copperGolem, class_2338 buttonBlockPos) {
        class_3218 serverWorld = (class_3218)copperGolem.method_37908();
        class_2680 blockState = serverWorld.method_8320(buttonBlockPos);
        if (!(blockState.method_26204() instanceof class_2269)) {
            return null;
        }
        return blockState;
    }
}

