/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.autopick;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.autopick.events.IBlockBreakEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingExpDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.IPlayerPickupItemEvent;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class AutoPickHelper {
    public static boolean isEnabled(Player player) {
        return AutoPickHelper.isPlayerEnabledAutoPick(player) && ModInfo.getServerConfig().enableAutoPick().get() != false;
    }

    private static boolean isPlayerEnabledAutoPick(Player player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().getWith(player).autoPicking();
    }

    public static void onLivingDrops(ILivingDropsEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (AutoPickHelper.isEnabled((Player)player)) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            for (ItemEntity drop : event.getDrops()) {
                ItemStack stack = drop.getItem();
                ItemStack remain = endInv.addItem(stack);
                stack.split(remain.getCount());
                if (!stack.isEmpty()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.isEmpty()) {
                    drop.remove(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                drop.setItem(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            }
        }
    }

    public static void onExpDrops(ILivingExpDropsEvent event) {
        Player player = event.getAttackingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!AutoPickHelper.isEnabled((Player)player2)) {
                return;
            }
            int exp = event.getDroppedExperience();
            int newValue = AutoPickHelper.repairPlayerItems((Player)player2, exp);
            player2.giveExperiencePoints(newValue);
            event.setCanceled(true);
        }
    }

    public static void onBlockBreak(IBlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!AutoPickHelper.isEnabled((Player)player2)) {
            return;
        }
        EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player2).orElse(null);
        if (endInv == null) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player2, (ItemStack)player2.getMainHandItem());
        if (event.getExpToDrop() > 0) {
            int exp = event.getExpToDrop();
            int repaired = AutoPickHelper.repairPlayerItems((Player)player2, exp);
            player2.giveExperiencePoints(repaired);
            event.setExpToDrop(0);
        }
        boolean allPicked = true;
        for (ItemStack drop : drops) {
            ItemStack remain = endInv.addItem(drop.copy());
            drop.shrink(remain.getCount());
            if (!drop.isEmpty()) {
                ModInfo.getPacketDistributor().sendToPlayer(player2, new ItemPickedUpPayload(drop));
            }
            if (remain.isEmpty()) continue;
            allPicked = false;
            level.addFreshEntity((Entity)new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, remain));
        }
        if (allPicked) {
            event.setCanceled(true);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static void onPickupItem(IPlayerPickupItemEvent event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (!(player2 instanceof ServerPlayer) || AutoPickHelper.isEnabled((Player)(player = (ServerPlayer)player2))) {
            return;
        }
        ItemEntity entity = event.getItem();
        if (entity.hasPickUpDelay()) {
            return;
        }
        ItemStack stack = entity.getItem();
        if (AutoPickHelper.shouldMoveTo((Player)player, stack)) {
            ServerLevelEndInv.getEndInvForPlayer((Player)player).ifPresent(endInv -> {
                ItemStack remain = endInv.addItem(stack.copy());
                if (!stack.isEmpty()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack.copy()));
                }
                if (remain.isEmpty()) {
                    stack.setCount(0);
                } else {
                    stack.split(remain.getCount());
                }
            });
        }
    }

    private static boolean shouldMoveTo(Player player, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof SwordItem) {
            SwordItem swordItem = (SwordItem)item;
            return AutoPickHelper.hasSuch(player, (Item)swordItem);
        }
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)axeItem);
        }
        if (item instanceof PickaxeItem) {
            PickaxeItem such = (PickaxeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShovelItem) {
            ShovelItem such = (ShovelItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof HoeItem) {
            HoeItem such = (HoeItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof TridentItem) {
            TridentItem such = (TridentItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShieldItem) {
            ShieldItem such = (ShieldItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ShearsItem) {
            ShearsItem such = (ShearsItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof BoatItem) {
            BoatItem such = (BoatItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ElytraItem) {
            ElytraItem such = (ElytraItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof BowItem) {
            BowItem such = (BowItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof CrossbowItem) {
            CrossbowItem such = (CrossbowItem)item;
            return AutoPickHelper.hasSuch(player, (Item)such);
        }
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return AutoPickHelper.hasOrSwearing(player, armorItem);
        }
        return !AutoPickHelper.canMerge(player, stack);
    }

    private static boolean canMerge(Player player, ItemStack stack) {
        return player.inventoryMenu.slots.stream().anyMatch(slot -> ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)stack));
    }

    private static boolean hasSuch(Player player, Item item) {
        return player.inventoryMenu.slots.stream().anyMatch(slot -> slot.getItem().getItem().getClass() == item.getClass());
    }

    private static boolean hasOrSwearing(Player player, ArmorItem armor) {
        EquipmentSlot slot = armor.getEquipmentSlot();
        ItemStack equipped = player.getItemBySlot(slot);
        if (equipped.isEmpty()) {
            return player.inventoryMenu.slots.stream().anyMatch(slt -> {
                ArmorItem a1;
                Item patt0$temp = slt.getItem().getItem();
                return patt0$temp instanceof ArmorItem && (a1 = (ArmorItem)patt0$temp).getEquipmentSlot() == slot;
            });
        }
        return true;
    }

    private static int repairPlayerItems(Player player, int repairAmount) {
        return repairAmount;
    }
}

