/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.page.ItemDisplay;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SegClassifyItemDisplay
extends ItemDisplay {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Predicate<ItemStack>> subClassifies;
    private final boolean includeRemainItems;
    private final boolean keepClassifiedItemInNextSeg;
    private final List<ItemStack> segmentedView = new ArrayList<ItemStack>();
    private final List<Integer> segmentStartSlots = new ArrayList<Integer>();
    private final List<Integer> pageSeparatorRows = new ArrayList<Integer>();

    public SegClassifyItemDisplay(PageType pageType, PageManager metaDataManager, List<Predicate<ItemStack>> subClassifies, boolean includeRemainItems, boolean keepClassifiedItemInNextSeg) {
        super(pageType, metaDataManager);
        this.subClassifies = subClassifies == null ? List.of() : List.copyOf(subClassifies);
        this.includeRemainItems = includeRemainItems;
        this.keepClassifiedItemInNextSeg = keepClassifiedItemInNextSeg;
    }

    @Override
    public void readCachedItems() {
        List<ItemStack> source = CachedSrcInv.INSTANCE.getSortedAndFilteredItemView(0, Integer.MAX_VALUE, CachedConfig.sortType(), CachedConfig.reverseSort(), this.getClassify(), CachedConfig.searching());
        this.buildContentsWith(source);
    }

    @Override
    public void buildContentsWith(@NotNull List<ItemStack> stacks) {
        if (this.holdOn) {
            this.inQueueStacks = stacks;
            return;
        }
        this.rebuildSegments(stacks);
    }

    private void buildContentDirectly(List<ItemStack> stacks) {
        for (int i = 0; i < this.length; ++i) {
            if (i < stacks.size() && stacks.get(i) != null) {
                this.items.set(i, (Object)stacks.get(i).copy());
                continue;
            }
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        int columns = this.meta.columns();
        for (ItemStack item : this.items) {
            if (columnIndex == 0 && this.pageSeparatorRows.contains(rowIndex)) {
                int y = this.topPos + rowIndex * 18;
                guiGraphics.fill(this.leftPos, y, this.leftPos + columns * 18 - 2, y + 1, -10855846);
            }
            if (item.isEmpty() && !item.is(Items.AIR)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, item);
            }
            guiGraphics.renderItem(item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, item, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(item));
            }
            if (++columnIndex < columns) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.pose().popPose();
    }

    @Override
    public void pageClicked(double XOffset, double YOffset, int button, ClickType clickType) {
        ItemStack clicked;
        int slot = this.getSlotByMouseOffset(XOffset, YOffset);
        if (slot < 0 || slot >= this.items.size()) {
            return;
        }
        int viewIndex = this.startIndex + slot;
        ItemStack itemStack = clicked = viewIndex < this.segmentedView.size() ? this.segmentedView.get(viewIndex).copy() : ItemStack.EMPTY;
        if (clicked.isEmpty()) {
            return;
        }
        switch (clickType) {
            case PICKUP: {
                this.handlePickup(clicked, button);
                break;
            }
            case QUICK_MOVE: {
                this.handleQuickMove(clicked);
                break;
            }
            case SWAP: {
                this.handleSwap(clicked, button);
                break;
            }
            case THROW: {
                this.handleThrow(clicked);
                break;
            }
            case PICKUP_ALL: {
                this.handlePickupAll(clicked);
                break;
            }
            case CLONE: {
                this.handleClone(clicked);
                break;
            }
        }
        LOGGER.info("EI:sending:ItemClickPayload: player={} clickType={} button={} stack={}", new Object[]{this.meta.getPlayer(), clickType, button, clicked});
        ModInfo.getPacketDistributor().sendToServer(new ItemClickPayload(clicked.getCount() > 64 ? clicked.copyWithCount(64) : clicked.copy(), button, clickType));
        this.refreshItems();
    }

    @Override
    public ItemStack takeItem(ItemStack itemStack, int count) {
        this.setChanged();
        ItemStack result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public ItemStack takeItem(int index, int count) {
        int viewIndex = this.startIndex + index;
        if (viewIndex < 0 || viewIndex >= this.segmentedView.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack = this.segmentedView.get(viewIndex);
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        ItemStack result = this.srcInv.takeItem(itemStack, count);
        this.readCachedItems();
        return result;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        ItemStack remain = this.srcInv.addItem(itemStack.copy());
        this.readCachedItems();
        return remain;
    }

    private void rebuildSegments(List<ItemStack> source) {
        this.segmentedView.clear();
        this.segmentStartSlots.clear();
        this.pageSeparatorRows.clear();
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (ItemStack stack : source) {
            if (stack == null || stack.isEmpty()) continue;
            filtered.add(stack.copy());
        }
        if (filtered.isEmpty()) {
            this.buildContentDirectly(List.of());
            return;
        }
        boolean[] consumed = new boolean[filtered.size()];
        boolean[] matchedAtLeastOnce = new boolean[filtered.size()];
        for (Predicate<ItemStack> classifier : this.subClassifies) {
            if (classifier == null) continue;
            int start = this.segmentedView.size();
            ArrayList<ItemStack> segment = new ArrayList<ItemStack>();
            for (int i = 0; i < filtered.size(); ++i) {
                ItemStack stack;
                if (!this.keepClassifiedItemInNextSeg && consumed[i] || !classifier.test(stack = (ItemStack)filtered.get(i))) continue;
                segment.add(stack.copy());
                matchedAtLeastOnce[i] = true;
                if (this.keepClassifiedItemInNextSeg) continue;
                consumed[i] = true;
            }
            if (segment.isEmpty()) continue;
            this.segmentStartSlots.add(start);
            this.appendSegment(this.segmentedView, segment);
        }
        if (this.includeRemainItems) {
            ArrayList<ItemStack> remain = new ArrayList<ItemStack>();
            for (int i = 0; i < filtered.size(); ++i) {
                boolean consumedFlag;
                boolean matched = matchedAtLeastOnce[i];
                boolean bl = consumedFlag = this.keepClassifiedItemInNextSeg ? matched : consumed[i];
                if (consumedFlag) continue;
                remain.add(((ItemStack)filtered.get(i)).copy());
            }
            if (!remain.isEmpty()) {
                this.segmentStartSlots.add(this.segmentedView.size());
                this.appendSegment(this.segmentedView, remain);
            }
        }
        this.updateDisplayedSlice();
    }

    private void appendSegment(List<ItemStack> target, List<ItemStack> segment) {
        if (segment.isEmpty()) {
            return;
        }
        target.addAll(segment);
        int columns = this.meta.columns();
        if (columns <= 0) {
            return;
        }
        int remainder = segment.size() % columns;
        if (remainder == 0) {
            return;
        }
        int filler = columns - remainder;
        for (int i = 0; i < filler; ++i) {
            target.add(ItemStack.EMPTY);
        }
    }

    private void updateDisplayedSlice() {
        int columns = Math.max(1, this.meta.columns());
        int fromIndex = Math.min(this.startIndex, this.segmentedView.size());
        int toIndex = Math.min(fromIndex + this.length, this.segmentedView.size());
        List<ItemStack> slice = this.segmentedView.subList(fromIndex, toIndex);
        this.buildContentDirectly(slice);
        this.pageSeparatorRows.clear();
        if (!this.segmentStartSlots.isEmpty()) {
            int firstRow = fromIndex / columns;
            int rowEndExclusive = Mth.positiveCeilDiv((int)Math.max(toIndex, fromIndex), (int)columns);
            for (Integer start : this.segmentStartSlots) {
                int relative;
                int row;
                if (start == null || (row = start / columns) <= firstRow || row >= rowEndExclusive || this.pageSeparatorRows.contains(relative = row - firstRow)) continue;
                this.pageSeparatorRows.add(relative);
            }
            if (!this.pageSeparatorRows.isEmpty()) {
                this.pageSeparatorRows.sort(Integer::compareTo);
            }
        }
    }
}

