/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu.page.pageManager;

import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PageQuickMoveHandler {
    private final AbstractContainerMenu menu;

    public PageQuickMoveHandler(PageMetaDataManager manager) {
        this.menu = manager.getMenu();
    }

    public PageQuickMoveHandler(AbstractContainerMenu menu) {
        this.menu = menu;
    }

    public ItemStack quickMoveFromPage(ItemStack stack) {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof PageQuickMoveOverride) {
            PageQuickMoveOverride override = (PageQuickMoveOverride)abstractContainerMenu;
            stack = override.quickMoveFromPage(stack);
        } else {
            this.moveItemStackTo(stack, 0, this.menu.slots.size() - 1, this.menu instanceof InventoryMenu);
        }
        return stack;
    }

    public boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.menu.slots.get(i);
                ItemStack itemstack = slot.getItem();
                if (!itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        stack.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.setChanged();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.menu.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(stack)) {
                    int l = slot1.getMaxStackSize(stack);
                    slot1.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static interface PageQuickMoveOverride {
        public ItemStack quickMoveFromPage(ItemStack var1);
    }
}

