/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public record ItemClickPayload(ItemStack stack, int button, ClickType clickType) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemClickPayload> STREAM_CODEC = StreamCodec.of((buf, value) -> ItemClickPayload.encode(value, buf), ItemClickPayload::decode);
    public static final CustomPacketPayload.Type<ItemClickPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("item_click"));
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemClickPayload decode(RegistryFriendlyByteBuf buf) {
        return new ItemClickPayload((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf), buf.readInt(), (ClickType)buf.readEnum(ClickType.class));
    }

    public static void encode(ItemClickPayload itemClickPayload, RegistryFriendlyByteBuf o) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)o, (Object)itemClickPayload.stack);
        o.writeInt(itemClickPayload.button);
        o.writeEnum((Enum)itemClickPayload.clickType);
    }

    @Override
    public void handle(ModPacketContext context) {
        Player player = context.player();
        AbstractContainerMenu menu = player.containerMenu;
        ItemStack carried = menu.getCarried();
        LOGGER.debug("EI:ItemClickPayload.handle: player={} clickType={} button={} carriedEmpty={} stack={}", new Object[]{player.getName().getString(), this.clickType, this.button, carried.isEmpty(), this.stack});
        Optional<EndlessInventory> opt = ServerLevelEndInv.getEndInvForPlayer(player);
        if (opt.isEmpty()) {
            LOGGER.warn("ItemClickPayload.handle: no EndInv for player={}", (Object)player.getName().getString());
            return;
        }
        EndlessInventory endInv = opt.get();
        block0 : switch (this.clickType) {
            case PICKUP: {
                if (!carried.isEmpty()) {
                    ItemStack remain = endInv.addItem(carried);
                    menu.setCarried(remain);
                    endInv.setChanged();
                    break;
                }
                int count = Math.min(this.stack.getCount(), this.stack.getMaxStackSize());
                int takenCount = this.button == 0 ? count : (count + 1) / 2;
                ItemStack taken = endInv.takeItem(this.stack, takenCount);
                LOGGER.debug("ItemClickPayload.PICKUP: taken={} from stack={}", (Object)taken, (Object)this.stack);
                if (player.isCreative() && menu instanceof InventoryMenu) {
                    LOGGER.info("Ignored taken item on server thread in Creative mode to prevent duplication.");
                } else {
                    menu.setCarried(taken);
                }
                if (this.stack.isEmpty()) break;
                endInv.setChanged();
                break;
            }
            case SWAP: {
                ItemStack remain;
                Inventory inventory = player.getInventory();
                ItemStack inventoryItem = inventory.getItem(this.button);
                boolean a = !inventoryItem.isEmpty();
                boolean b = !this.stack.isEmpty();
                LOGGER.debug("ItemClickPayload.SWAP: inventoryItem={} clickedStack={}", (Object)inventoryItem, (Object)this.stack);
                if (a && !b) {
                    remain = endInv.addItem(inventoryItem);
                    inventory.setItem(this.button, remain);
                    LOGGER.debug("ItemClickPayload.SWAP: added inventoryItem, remain={}", (Object)remain);
                }
                if (!a && b) {
                    ItemStack swapping = endInv.takeItem(this.stack);
                    inventory.setItem(this.button, swapping);
                    LOGGER.debug("ItemClickPayload.SWAP: took from endInv swapping={}", (Object)swapping);
                }
                if (a && b) {
                    remain = endInv.addItem(inventoryItem);
                    LOGGER.debug("ItemClickPayload.SWAP: both non-empty, remainFromAdd={}", (Object)remain);
                    if (remain.isEmpty()) {
                        ItemStack swapping = endInv.takeItem(this.stack);
                        inventory.setItem(this.button, swapping);
                        LOGGER.debug("ItemClickPayload.SWAP: swap success swapping={}", (Object)swapping);
                    } else {
                        inventory.setItem(this.button, remain);
                    }
                }
                endInv.setChanged();
                break;
            }
            case THROW: {
                ItemStack thrown = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.THROW: thrown={}", (Object)thrown);
                player.drop(thrown, true);
                endInv.setChanged();
                break;
            }
            case PICKUP_ALL: {
                int startIndex;
                for (int index = startIndex = menu.slots.size() - 1; index >= 0; --index) {
                    Slot scanning = (Slot)menu.slots.get(index);
                    if (!(scanning.container instanceof Inventory)) break block0;
                    ItemStack scanningItem = scanning.getItem();
                    if (!ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)scanningItem)) continue;
                    ItemStack taken = scanning.safeTake(scanningItem.getCount(), scanningItem.getCount(), player);
                    LOGGER.debug("ItemClickPayload.PICKUP_ALL: took {} from slot index={}", (Object)taken, (Object)index);
                    ItemStack remain = endInv.addItem(taken);
                    if (!remain.isEmpty()) {
                        scanning.set(remain);
                    }
                    endInv.setChanged();
                }
                break;
            }
            case CLONE: {
                if (!player.isCreative() || !carried.isEmpty()) break;
                menu.setCarried(this.stack.copyWithCount(this.stack.getMaxStackSize()));
                LOGGER.debug("ItemClickPayload.CLONE: cloned stack={}", (Object)this.stack);
                break;
            }
            case QUICK_MOVE: {
                ItemStack taken = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: taken={}", (Object)taken);
                ItemStack remain = new PageQuickMoveHandler(menu).quickMoveFromPage(taken);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: remain after quickMove={}", (Object)remain);
                endInv.addItem(remain);
                endInv.setChanged();
            }
        }
    }

    @Override
    public String id() {
        return "item_click";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

