/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record StarItemPayload(ItemStack stack, boolean isAdding) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, StarItemPayload> STREAM_CODEC = StreamCodec.of((buf, value) -> StarItemPayload.encode(value, buf), StarItemPayload::decode);
    public static final CustomPacketPayload.Type<StarItemPayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("star_item"));

    public static void encode(StarItemPayload payload, RegistryFriendlyByteBuf o) {
        ItemStack.STREAM_CODEC.encode((Object)o, (Object)payload.stack);
        o.writeBoolean(payload.isAdding);
    }

    public static StarItemPayload decode(RegistryFriendlyByteBuf o) {
        return new StarItemPayload((ItemStack)ItemStack.STREAM_CODEC.decode((Object)o), o.readBoolean());
    }

    @Override
    public String id() {
        return "star_item";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        ServerPlayer player = (ServerPlayer)iPayloadContext.player();
        if (player == null) {
            return;
        }
        ServerLevelEndInv.getEndInvForPlayer((Player)player).ifPresent(endInv -> {
            if (this.isAdding()) {
                endInv.affinities.addStarredItem(this.stack());
            } else {
                endInv.affinities.removeStarredItem(this.stack());
            }
            endInv.setChanged();
        });
    }
}

