/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.util;

import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class SearchUtil {
    public static boolean matchesSearch(ItemStack stack, String search) {
        String[] terms;
        if (search == null || search.isEmpty()) {
            return true;
        }
        for (String term : terms = search.toLowerCase(Locale.ROOT).trim().split("\\s+")) {
            if (SearchUtil.matchesSingleTerm(stack, term)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesSingleTerm(ItemStack stack, String term) {
        if (term.startsWith("#")) {
            return SearchUtil.matchesTag(stack, term.substring(1));
        }
        if (term.startsWith("*")) {
            return SearchUtil.matchesId(stack, term.substring(1));
        }
        if (term.startsWith("^")) {
            return SearchUtil.matchesTooltip(stack, term.substring(1));
        }
        if (term.startsWith("@")) {
            return SearchUtil.matchesNamespace(stack, term.substring(1));
        }
        return SearchUtil.matchesName(stack, term);
    }

    private static boolean matchesTag(ItemStack stack, String tagId) {
        return stack.getTags().anyMatch(tag -> tag.location().toString().toLowerCase(Locale.ROOT).contains(tagId));
    }

    private static boolean matchesId(ItemStack stack, String idSearch) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return id.toString().toLowerCase(Locale.ROOT).contains(idSearch);
    }

    private static boolean matchesTooltip(ItemStack stack, String tooltipSearch) {
        return stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(tooltipSearch);
    }

    private static boolean matchesName(ItemStack stack, String nameSearch) {
        if (stack.getHoverName().getString().toLowerCase(Locale.ROOT).contains(nameSearch)) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return id.getPath().toLowerCase(Locale.ROOT).contains(nameSearch);
    }

    private static boolean matchesNamespace(ItemStack stack, String nsSearch) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return id.getNamespace().toLowerCase(Locale.ROOT).contains(nsSearch);
    }
}

