/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.events;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import com.kwwsyk.endinv.neoforge.options.ServerConfig;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;

@EventBusSubscriber(modid="endless_inventory")
public class LootEvent {
    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!LootEvent.isPlayerEnabledAutoPick((Player)player)) {
            return;
        }
        if (ServerConfig.CONFIG.ENABLE_AUTO_PICK.getAsBoolean()) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            for (ItemEntity drop : event.getDrops()) {
                ItemStack stack = drop.getItem();
                ItemStack remain = endInv.addItem(stack);
                stack.split(remain.getCount());
                if (!stack.isEmpty()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.isEmpty()) {
                    drop.remove(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                drop.setItem(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockDropsEvent event) {
        Entity entity = event.getBreaker();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!LootEvent.isPlayerEnabledAutoPick((Player)player)) {
            return;
        }
        if (ServerConfig.CONFIG.ENABLE_AUTO_PICK.getAsBoolean()) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            int exp = event.getDroppedExperience();
            int newValue = LootEvent.repairPlayerItems(player, exp);
            player.giveExperiencePoints(newValue);
            for (ItemEntity drop : event.getDrops()) {
                ItemStack stack = drop.getItem();
                ItemStack remain = endInv.addItem(stack);
                stack.split(remain.getCount());
                if (!stack.isEmpty()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.isEmpty()) {
                    drop.remove(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                drop.setItem(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            } else {
                event.setDroppedExperience(0);
            }
        }
    }

    @SubscribeEvent
    public static void onExpDrops(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!LootEvent.isPlayerEnabledAutoPick((Player)player2) || !ServerConfig.CONFIG.ENABLE_AUTO_PICK.getAsBoolean()) {
                return;
            }
            int exp = event.getDroppedExperience();
            int newValue = LootEvent.repairPlayerItems(player2, exp);
            player2.giveExperiencePoints(newValue);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPickupItem(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer && ServerConfig.CONFIG.ENABLE_AUTO_PICK.getAsBoolean() && LootEvent.isPlayerEnabledAutoPick(player))) {
            return;
        }
        ItemEntity entity = event.getItemEntity();
        if (entity.hasPickUpDelay() || entity.getTarget() != null && entity.getTarget() != player.getUUID()) {
            return;
        }
        ItemStack stack = entity.getItem();
        if (LootEvent.shouldMoveTo(player, stack)) {
            ServerLevelEndInv.getEndInvForPlayer(player).ifPresent(endInv -> {
                ItemStack remain = endInv.addItem(stack.copy());
                if (!stack.isEmpty()) {
                    ModInfo.getPacketDistributor().sendToPlayer((ServerPlayer)player, new ItemPickedUpPayload(stack.copy()));
                }
                if (remain.isEmpty()) {
                    stack.setCount(0);
                } else {
                    stack.split(remain.getCount());
                }
            });
        }
    }

    private static boolean shouldMoveTo(Player player, ItemStack stack) {
        Item item;
        if (stack.isEmpty()) {
            return false;
        }
        Item item2 = item = stack.getItem();
        Objects.requireNonNull(item2);
        Item item3 = item2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SwordItem.class, AxeItem.class, PickaxeItem.class, ShovelItem.class, HoeItem.class, TridentItem.class, ShieldItem.class, ShearsItem.class, BoatItem.class, ElytraItem.class, BowItem.class, CrossbowItem.class, MaceItem.class, ArmorItem.class}, (Object)item3, n)) {
            case 0: {
                SwordItem swordItem = (SwordItem)item3;
                return LootEvent.hasSuch(player, (Item)swordItem);
            }
            case 1: {
                AxeItem axeItem = (AxeItem)item3;
                return LootEvent.hasSuch(player, (Item)axeItem);
            }
            case 2: {
                PickaxeItem such = (PickaxeItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 3: {
                ShovelItem such = (ShovelItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 4: {
                HoeItem such = (HoeItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 5: {
                TridentItem such = (TridentItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 6: {
                ShieldItem such = (ShieldItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 7: {
                ShearsItem such = (ShearsItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 8: {
                BoatItem such = (BoatItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 9: {
                ElytraItem such = (ElytraItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 10: {
                BowItem such = (BowItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 11: {
                CrossbowItem such = (CrossbowItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 12: {
                MaceItem such = (MaceItem)item3;
                return LootEvent.hasSuch(player, (Item)such);
            }
            case 13: {
                ArmorItem armorItem = (ArmorItem)item3;
                return LootEvent.hasOrSwearing(player, armorItem);
            }
        }
        return !LootEvent.canMerge(player, stack);
    }

    private static boolean canMerge(Player player, ItemStack stack) {
        return player.inventoryMenu.slots.stream().anyMatch(slot -> ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)stack));
    }

    private static boolean hasSuch(Player player, Item item) {
        return player.inventoryMenu.slots.stream().anyMatch(slot -> slot.getItem().getItem().getClass() == item.getClass());
    }

    private static boolean hasOrSwearing(Player player, ArmorItem armor) {
        EquipmentSlot slot = armor.getEquipmentSlot();
        ItemStack equipped = player.getItemBySlot(slot);
        if (equipped.isEmpty()) {
            return player.inventoryMenu.slots.stream().anyMatch(slt -> {
                ArmorItem a1;
                Item patt0$temp = slt.getItem().getItem();
                return patt0$temp instanceof ArmorItem && (a1 = (ArmorItem)patt0$temp).getEquipmentSlot() == slot;
            });
        }
        return true;
    }

    private static int repairPlayerItems(ServerPlayer player, int value) {
        Optional optional = EnchantmentHelper.getRandomItemWith((DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP, (LivingEntity)player, ItemStack::isDamaged);
        if (optional.isPresent()) {
            int k;
            ItemStack itemstack = ((EnchantedItemInUse)optional.get()).itemStack();
            int i = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)player.serverLevel(), (ItemStack)itemstack, (int)((int)((float)value * itemstack.getXpRepairRatio())));
            int j = Math.min(i, itemstack.getDamageValue());
            itemstack.setDamageValue(itemstack.getDamageValue() - j);
            if (j > 0 && (k = value - j * value / i) > 0) {
                return LootEvent.repairPlayerItems(player, k);
            }
            return 0;
        }
        return value;
    }

    private static boolean isPlayerEnabledAutoPick(Player player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().computeIfAbsent(player).autoPicking();
    }
}

