/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.integrates.jei.experimental;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.gui.AttachingScreen;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.neoforge.client.events.ScreenAttachment;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;

public final class AEIRecipeTransferHandler {
    private AEIRecipeTransferHandler() {
    }

    public static <C extends AbstractContainerMenu, R> Optional<TransferContext> prepareClientContext(C container, R recipe, IRecipeSlotsView recipeSlotsView, Player player, boolean maxTransfer, IRecipeTransferInfo<C, R> transferInfo, List<Slot> recipeSlots, List<Slot> inventorySlots) {
        ResourceLocation recipeId;
        SourceInventory endInv = AEIRecipeTransferHandler.getClientAttachedInventory(container);
        if (endInv == null && ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL) {
            endInv = CachedSrcInv.INSTANCE;
        }
        Ingredient[] layout = AEIRecipeTransferHandler.buildLayoutFromRecipeSlots(recipeSlotsView, recipeSlots.size());
        TransferPlan plan = null;
        if (endInv != null) {
            if (AEIRecipeTransferHandler.allEmpty(layout) && recipe instanceof Recipe) {
                Recipe mcRecipe = (Recipe)recipe;
                plan = AEIRecipeTransferHandler.createTransferPlan(mcRecipe, recipeSlots, inventorySlots, endInv, maxTransfer);
            } else {
                plan = AEIRecipeTransferHandler.createTransferPlan(layout, recipeSlots, inventorySlots, endInv, maxTransfer);
            }
            if (plan.isMissing() || plan.craftsWanted() <= 0) {
                return Optional.empty();
            }
        }
        if ((recipeId = AEIRecipeTransferHandler.tryResolveRecipeId(recipe)) == null) {
            recipeId = ResourceLocation.fromNamespaceAndPath((String)"endless_inventory", (String)("jei/unknown/" + container.containerId));
        }
        boolean requireCompleteSets = transferInfo.requireCompleteSets(container, recipe);
        List<Integer> craftingIndexes = recipeSlots.stream().map(slot -> slot.index).toList();
        List<Integer> inventoryIndexes = inventorySlots.stream().map(slot -> slot.index).toList();
        return Optional.of(new TransferContext(container.containerId, recipeId, maxTransfer, requireCompleteSets, craftingIndexes, inventoryIndexes));
    }

    @Nullable
    private static SourceInventory getClientAttachedInventory(AbstractContainerMenu container) {
        if (EffectiveSide.get() == LogicalSide.SERVER) {
            return null;
        }
        return ClientAccess.getAttachedInventory(container);
    }

    public static void performServerTransfer(AbstractContainerMenu container, Recipe<?> recipe, List<Slot> recipeSlots, List<Slot> inventorySlots, ServerPlayer player, @Nullable PageMetaDataManager manager, boolean maxTransfer, boolean requireCompleteSets) {
        SourceInventory endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
        if (endInv == null) {
            return;
        }
        TransferPlan plan = AEIRecipeTransferHandler.createTransferPlan(recipe, recipeSlots, inventorySlots, endInv, maxTransfer);
        if (plan.isMissing() || plan.craftsWanted() <= 0) {
            return;
        }
        AEIRecipeTransferHandler.performTransfer(container, plan, (Player)player, recipeSlots, inventorySlots, endInv);
        if (manager != null) {
            manager.sendEndInvData();
        } else {
            ContentTransferMode mode = ModInfo.getServerConfig().transferMode().get();
            switch (mode) {
                case ALL: {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new EndInvContent(endInv.getItemMap()));
                    break;
                }
                case PART: {
                    ModInfo.getPacketDistributor().sendToPlayer(player, EndInvMetadata.getWith((EndlessInventory)endInv));
                }
            }
        }
    }

    @Nullable
    public static PageMetaDataManager getServerManager(ServerPlayer player) {
        return ServerLevelEndInv.checkAndGetManagerForPlayer(player).orElse(null);
    }

    private static TransferPlan createTransferPlan(Recipe<?> recipe, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv, boolean maxTransfer) {
        Ingredient[] layout = AEIRecipeTransferHandler.buildRecipeLayout(recipe, recipeSlots.size());
        return AEIRecipeTransferHandler.createTransferPlan(layout, recipeSlots, inventorySlots, endInv, maxTransfer);
    }

    private static TransferPlan createTransferPlan(Ingredient[] layout, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv, boolean maxTransfer) {
        int craftsPossible;
        List<ItemStack> pageItems = endInv.getItemsAsList();
        ItemAvailability availability = ItemAvailability.build(Collections.emptyList(), pageItems);
        Reservation reservation = new Reservation();
        Object[] chosenPerSlot = new ItemStack[layout.length];
        Arrays.fill(chosenPerSlot, ItemStack.EMPTY);
        boolean missing = false;
        int perSlotStackLimit = Integer.MAX_VALUE;
        for (int i = 0; i < layout.length; ++i) {
            Ingredient ing = layout[i];
            if (ing.isEmpty()) continue;
            Selection selection = AEIRecipeTransferHandler.chooseBestCandidate(ing, availability, reservation);
            if (selection.isEmpty()) {
                missing = true;
                continue;
            }
            reservation.reserve(selection);
            chosenPerSlot[i] = selection.stack();
            perSlotStackLimit = Math.min(perSlotStackLimit, selection.stack().getMaxStackSize());
        }
        if (missing || reservation.isEmpty()) {
            craftsPossible = 0;
        } else {
            craftsPossible = Integer.MAX_VALUE;
            for (Map.Entry entry : reservation.totalDemand().entrySet()) {
                ItemCounts counts = availability.lookup((ItemKey)entry.getKey());
                if (counts == null) {
                    craftsPossible = 0;
                    missing = true;
                    break;
                }
                int possible = counts.total() / (Integer)entry.getValue();
                craftsPossible = Math.min(craftsPossible, possible);
            }
            if (craftsPossible == Integer.MAX_VALUE) {
                craftsPossible = 0;
            }
        }
        if (perSlotStackLimit == Integer.MAX_VALUE) {
            perSlotStackLimit = 64;
        }
        int craftsWanted = maxTransfer ? Math.min(craftsPossible, perSlotStackLimit) : (craftsPossible > 0 ? 1 : 0);
        boolean bl = missing || craftsWanted <= 0;
        return new TransferPlan(layout, (ItemStack[])chosenPerSlot, craftsWanted, bl);
    }

    private static void performTransfer(AbstractContainerMenu container, TransferPlan plan, Player player, List<Slot> recipeSlots, List<Slot> inventorySlots, SourceInventory endInv) {
        for (Slot cSlot : recipeSlots) {
            ItemStack removed;
            int count;
            if (!cSlot.hasItem() || (count = cSlot.getItem().getCount()) <= 0 || (removed = cSlot.safeTake(count, count, player)).isEmpty()) continue;
            player.getInventory().placeItemBackInInventory(removed);
        }
        Ingredient[] layout = plan.layout();
        for (int i = 0; i < Math.min(recipeSlots.size(), layout.length); ++i) {
            Object extracted;
            ItemStack template;
            Ingredient ing = layout[i];
            if (ing.isEmpty()) continue;
            Slot target = recipeSlots.get(i);
            int toTake = plan.craftsWanted();
            if (toTake <= 0) continue;
            ItemStack chosen = plan.chosenPerSlot()[i];
            Object placedStack = ItemStack.EMPTY;
            ItemStack itemStack = !chosen.isEmpty() ? chosen : (template = ing.getItems().length > 0 ? ing.getItems()[0] : ItemStack.EMPTY);
            if (!template.isEmpty() && !(extracted = endInv.takeItem(template, toTake)).isEmpty()) {
                if (placedStack.isEmpty()) {
                    placedStack = extracted;
                } else if (AEIRecipeTransferHandler.sameType(placedStack, (ItemStack)extracted)) {
                    placedStack.grow(extracted.getCount());
                } else {
                    player.getInventory().placeItemBackInInventory((ItemStack)extracted);
                }
                toTake -= extracted.getCount();
            }
            if (toTake > 0) {
                extracted = inventorySlots.iterator();
                while (extracted.hasNext()) {
                    ItemStack taken;
                    int can;
                    Slot invSlot = (Slot)extracted.next();
                    if (toTake <= 0) break;
                    if (!invSlot.hasItem()) continue;
                    ItemStack in = invSlot.getItem();
                    if (!(chosen.isEmpty() ? ing.test(in) : AEIRecipeTransferHandler.sameType(chosen, in)) || (can = Math.min(toTake, in.getCount())) <= 0 || (taken = invSlot.safeTake(can, can, player)).isEmpty()) continue;
                    if (placedStack.isEmpty()) {
                        placedStack = taken;
                    } else if (AEIRecipeTransferHandler.sameType(placedStack, taken)) {
                        placedStack.grow(taken.getCount());
                    } else {
                        player.getInventory().placeItemBackInInventory(taken);
                        break;
                    }
                    toTake -= taken.getCount();
                }
            }
            if (placedStack.isEmpty()) continue;
            int cap = Math.min(placedStack.getMaxStackSize(), target.getMaxStackSize());
            if (placedStack.getCount() > cap) {
                ItemStack overflow = placedStack.copyWithCount(placedStack.getCount() - cap);
                placedStack.setCount(cap);
                player.getInventory().placeItemBackInInventory(overflow);
            }
            target.set(placedStack);
        }
        container.broadcastChanges();
    }

    private static boolean sameType(ItemStack a, ItemStack b) {
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    private static Ingredient[] buildRecipeLayout(Recipe<?> recipe, int targetSlots) {
        Object[] layout = new Ingredient[targetSlots];
        Arrays.fill(layout, Ingredient.EMPTY);
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int gridW = targetSlots == 9 ? 3 : (targetSlots == 4 ? 2 : shaped.getWidth());
            int gridH = gridW > 0 ? targetSlots / gridW : 0;
            int width = Math.min(gridW, shaped.getWidth());
            int height = Math.min(gridH, shaped.getHeight());
            NonNullList ingredients = shaped.getIngredients();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int srcIndex = y * shaped.getWidth() + x;
                    int dstIndex = y * gridW + x;
                    if (srcIndex >= ingredients.size() || dstIndex >= targetSlots) continue;
                    layout[dstIndex] = (Ingredient)ingredients.get(srcIndex);
                }
            }
        } else {
            NonNullList ingredients = recipe.getIngredients();
            for (int i = 0; i < Math.min(ingredients.size(), layout.length); ++i) {
                layout[i] = (Ingredient)ingredients.get(i);
            }
        }
        return layout;
    }

    private static Ingredient[] buildLayoutFromRecipeSlots(IRecipeSlotsView slotsView, int targetSlots) {
        Object[] layout = new Ingredient[targetSlots];
        Arrays.fill(layout, Ingredient.EMPTY);
        int i = 0;
        List lst = slotsView.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView slotView1 : lst) {
            if (i >= targetSlots) break;
            List<ItemStack> stacks = slotView1.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
            if (!stacks.isEmpty()) {
                layout[i] = Ingredient.of((ItemStack[])stacks.toArray(new ItemStack[0]));
            }
            ++i;
        }
        return layout;
    }

    private static boolean allEmpty(Ingredient[] layout) {
        for (Ingredient ing : layout) {
            if (ing.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static ResourceLocation tryResolveRecipeId(Object recipeObj) {
        Object v;
        Method m2;
        try {
            m2 = recipeObj.getClass().getMethod("getId", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("id", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)v;
                return rl;
            }
        }
        catch (Throwable m3) {
            // empty catch block
        }
        try {
            m2 = recipeObj.getClass().getMethod("value", new Class[0]);
            v = m2.invoke(recipeObj, new Object[0]);
            if (v != null) {
                return AEIRecipeTransferHandler.tryResolveRecipeId(v);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Selection chooseBestCandidate(Ingredient ing, ItemAvailability availability, Reservation reservation) {
        Candidate best = Candidate.NONE;
        HashSet<ItemKey> seen = new HashSet<ItemKey>();
        for (ItemStack cand : ing.getItems()) {
            ItemCounts counts = AEIRecipeTransferHandler.countAvailableOfType(cand, availability);
            Candidate candidate = Candidate.fromCounts(counts, reservation);
            if (!candidate.isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        for (ItemCounts counts : availability.all()) {
            Candidate candidate;
            if (!ing.test(counts.representative()) || !(candidate = Candidate.fromCounts(counts, reservation)).isValid() || !seen.add(candidate.selection().key())) continue;
            best = Candidate.pickBetter(best, candidate);
        }
        return best.selection();
    }

    @Nullable
    private static ItemCounts countAvailableOfType(ItemStack type, ItemAvailability availability) {
        if (type.isEmpty()) {
            return null;
        }
        return availability.lookup(ItemKey.asKey(type));
    }

    private record TransferPlan(Ingredient[] layout, ItemStack[] chosenPerSlot, int craftsWanted, boolean missing) {
        boolean isMissing() {
            return this.missing;
        }
    }

    public record TransferContext(int containerId, ResourceLocation recipeId, boolean maxTransfer, boolean requireCompleteSets, List<Integer> craftingSlotIndexes, List<Integer> inventorySlotIndexes) {
    }

    private static class ClientAccess {
        private ClientAccess() {
        }

        @Nullable
        private static SourceInventory getAttachedInventory(AbstractContainerMenu container) {
            AttachingScreen<?> attachment = ScreenAttachment.ATTACHMENT_MANAGER;
            if (attachment == null) {
                if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.ALL) {
                    return CachedSrcInv.INSTANCE;
                }
                return null;
            }
            if (Minecraft.getInstance().player == null) {
                return null;
            }
            if (attachment.getScreen().getMenu() != container) {
                return null;
            }
            return attachment.getFrameWork().getSourceInventory();
        }
    }

    private static final class ItemAvailability {
        private final Map<ItemKey, ItemCounts> counts = new HashMap<ItemKey, ItemCounts>();

        private ItemAvailability() {
        }

        static ItemAvailability build(List<Slot> invSlots, List<ItemStack> pageItems) {
            ItemAvailability availability = new ItemAvailability();
            for (Slot slot : invSlots) {
                if (!slot.hasItem()) continue;
                availability.add(slot.getItem(), Source.INVENTORY);
            }
            for (ItemStack stack : pageItems) {
                if (stack.isEmpty()) continue;
                availability.add(stack, Source.PAGE);
            }
            return availability;
        }

        private void add(ItemStack stack, Source source) {
            ItemKey key = ItemKey.asKey(stack);
            ItemCounts counts = this.counts.computeIfAbsent(key, k -> new ItemCounts((ItemKey)k, stack.copyWithCount(1)));
            counts.add(stack.getCount(), source);
        }

        @Nullable
        ItemCounts lookup(ItemKey key) {
            return this.counts.get(key);
        }

        Collection<ItemCounts> all() {
            return this.counts.values();
        }

        private static enum Source {
            INVENTORY,
            PAGE;

        }
    }

    private static final class Reservation {
        private final Map<ItemKey, Integer> total = new HashMap<ItemKey, Integer>();
        private final Map<ItemKey, Integer> inventory = new HashMap<ItemKey, Integer>();

        private Reservation() {
        }

        void reserve(Selection selection) {
            if (selection.key() == null) {
                return;
            }
            this.total.merge(selection.key(), 1, Integer::sum);
            if (selection.useInventory()) {
                this.inventory.merge(selection.key(), 1, Integer::sum);
            }
        }

        int totalReserved(ItemKey key) {
            return this.total.getOrDefault(key, 0);
        }

        int inventoryReserved(ItemKey key) {
            return this.inventory.getOrDefault(key, 0);
        }

        Map<ItemKey, Integer> totalDemand() {
            return this.total;
        }

        boolean isEmpty() {
            return this.total.isEmpty();
        }
    }

    private record Selection(ItemStack stack, ItemKey key, boolean useInventory) {
        static final Selection EMPTY = new Selection(ItemStack.EMPTY, null, false);

        boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    private static final class ItemCounts {
        private final ItemKey key;
        private final ItemStack representative;
        private int inventoryCount;
        private int pageCount;

        ItemCounts(ItemKey key, ItemStack representative) {
            this.key = key;
            this.representative = representative;
        }

        void add(int amount, ItemAvailability.Source source) {
            if (source == ItemAvailability.Source.INVENTORY) {
                this.inventoryCount += amount;
            } else {
                this.pageCount += amount;
            }
        }

        ItemKey key() {
            return this.key;
        }

        ItemStack representative() {
            return this.representative.copy();
        }

        int total() {
            return this.inventoryCount + this.pageCount;
        }

        int totalRemaining(Reservation reservation) {
            return this.total() - reservation.totalReserved(this.key);
        }

        int inventoryRemaining(Reservation reservation) {
            return this.inventoryCount - reservation.inventoryReserved(this.key);
        }

        boolean isPlain() {
            return this.key.components() != null && !this.key.components().isEmpty();
        }
    }

    private record Candidate(Selection selection, int priority, int totalRemaining, int inventoryRemaining) {
        private static final Candidate NONE = new Candidate(Selection.EMPTY, -1, 0, 0);

        boolean isValid() {
            return this.selection != null && !this.selection.isEmpty();
        }

        static Candidate fromCounts(@Nullable ItemCounts counts, Reservation reservation) {
            boolean hasPlainInventory;
            if (counts == null) {
                return NONE;
            }
            int totalRemaining = counts.totalRemaining(reservation);
            if (totalRemaining <= 0) {
                return NONE;
            }
            int inventoryRemaining = counts.inventoryRemaining(reservation);
            boolean hasInventory = inventoryRemaining > 0;
            boolean bl = hasPlainInventory = hasInventory && counts.isPlain();
            int priority = hasPlainInventory ? 3 : (hasInventory ? 2 : 1);
            Selection selection = new Selection(counts.representative(), counts.key(), hasInventory);
            return new Candidate(selection, priority, totalRemaining, inventoryRemaining);
        }

        static Candidate pickBetter(Candidate current, Candidate challenger) {
            if (!challenger.isValid()) {
                return current;
            }
            if (!current.isValid()) {
                return challenger;
            }
            if (challenger.priority != current.priority) {
                return challenger.priority > current.priority ? challenger : current;
            }
            if (challenger.totalRemaining != current.totalRemaining) {
                return challenger.totalRemaining > current.totalRemaining ? challenger : current;
            }
            if (challenger.inventoryRemaining != current.inventoryRemaining) {
                return challenger.inventoryRemaining > current.inventoryRemaining ? challenger : current;
            }
            return current;
        }
    }
}

