/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.mixin;

import com.kwwsyk.endinv.neoforge.options.StartupConfig;
import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            return StartupConfig.enableVanillaRecipeBookTransfer();
        }
        catch (IllegalStateException e) {
            Boolean v = MixinPlugin.readBooleanFromToml("mixin", "vanillaRecipeBookTransfer");
            if (v != null) {
                LOGGER.info("NeoForge mixin fallback read: mixin.vanillaRecipeBookTransfer={} ", (Object)v);
                return v;
            }
            LOGGER.warn("NeoForge mixin config not yet loaded; defaulting vanillaRecipeBookTransfer=true");
            return true;
        }
    }

    private static Boolean readBooleanFromToml(String section, String key) {
        Path[] candidates;
        String fileName = "endless_inventory-common.toml";
        for (Path p : candidates = new Path[]{Paths.get("run", "config", fileName), Paths.get("config", fileName), Paths.get(fileName, new String[0])}) {
            try {
                String content;
                Boolean b;
                if (!Files.isRegularFile(p, new LinkOption[0]) || (b = MixinPlugin.parseEnableFromToml(content = Files.readString(p), section, key)) == null) continue;
                return b;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static Boolean parseEnableFromToml(String content, String section, String key) {
        boolean inSection = false;
        for (String raw : content.split("\r?\n")) {
            int eq;
            String line = raw.trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("[")) {
                int r = line.indexOf(93);
                if (r > 1) {
                    String sect = line.substring(1, r).trim();
                    inSection = section.equals(sect);
                    continue;
                }
                inSection = false;
                continue;
            }
            if (!inSection) continue;
            int hash = line.indexOf(35);
            if (hash >= 0) {
                line = line.substring(0, hash).trim();
            }
            if (!line.startsWith(key) || (eq = line.indexOf(61)) < 0) continue;
            String rhs = line.substring(eq + 1).trim();
            if (rhs.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (!rhs.equalsIgnoreCase("false")) continue;
            return Boolean.FALSE;
        }
        return null;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

