/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.mixin;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.util.recipeTransferHelper.RecipeItemProvider;
import javax.annotation.Nullable;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlaceRecipe.class})
public class ServerPlaceRecipeMixin<C extends Container> {
    @Final
    @Shadow
    protected StackedContents stackedContents;
    @Unique
    @Nullable
    private EndlessInventory endInv;

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;fillCraftSlotsStackedContents(Lnet/minecraft/world/entity/player/StackedContents;)V")})
    private void fillEndInvStackedContents(ServerPlayer player, RecipeHolder<?> recipe, boolean placeAll, CallbackInfo ci) {
        this.endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
        if (this.endInv == null) {
            return;
        }
        RecipeItemProvider.fillStackedContents(this.endInv.getItemsAsList(), this.stackedContents);
    }

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/recipebook/ServerPlaceRecipe;handleRecipeClicked(Lnet/minecraft/world/item/crafting/RecipeHolder;Z)V")})
    private void finishHandleClick(ServerPlayer player, RecipeHolder<?> recipe, boolean placeAll, CallbackInfo ci) {
        if (this.endInv != null) {
            this.endInv.broadcastChanges();
        }
    }

    @Inject(method={"moveItemToGrid"}, at={@At(value="RETURN")}, cancellable=true)
    private void ei$afterMove(Slot slot, ItemStack stack, int maxAmount, CallbackInfoReturnable<Integer> cir) {
        if (this.endInv == null) {
            return;
        }
        int remaining = (Integer)cir.getReturnValue();
        if (remaining >= 0) {
            return;
        }
        ItemStack taken = this.endInv.takeItem(stack, maxAmount);
        if (taken.isEmpty()) {
            cir.setReturnValue((Object)maxAmount);
            return;
        }
        int newRemaining = maxAmount - taken.getCount();
        ItemStack slotItem = slot.getItem();
        if (slotItem.isEmpty()) {
            slot.set(taken.copy());
        } else {
            slotItem.grow(taken.getCount());
        }
        cir.setReturnValue((Object)newRemaining);
    }
}

