/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.network.payloads;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.neoforge.integrates.jei.EIMRecipeTranHandler;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record JeiTransferRecipePayload(int containerId, ResourceLocation recipeId, boolean maxTransfer) implements ModPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, JeiTransferRecipePayload> STREAM_CODEC = StreamCodec.of((buf, value) -> JeiTransferRecipePayload.encode(value, (FriendlyByteBuf)buf), JeiTransferRecipePayload::decode);
    public static final CustomPacketPayload.Type<JeiTransferRecipePayload> TYPE = new CustomPacketPayload.Type(AbstractModInitializer.withModLocation("jei_transfer_recipe"));
    private static final Logger log = LoggerFactory.getLogger(JeiTransferRecipePayload.class);

    public static void encode(JeiTransferRecipePayload payload, FriendlyByteBuf buffer) {
        buffer.writeVarInt(payload.containerId);
        buffer.writeResourceLocation(payload.recipeId);
        buffer.writeBoolean(payload.maxTransfer);
    }

    public static JeiTransferRecipePayload decode(FriendlyByteBuf buffer) {
        int containerId = buffer.readVarInt();
        ResourceLocation recipeId = buffer.readResourceLocation();
        boolean maxTransfer = buffer.readBoolean();
        return new JeiTransferRecipePayload(containerId, recipeId, maxTransfer);
    }

    @Override
    public String id() {
        return "jei_transfer_recipe";
    }

    @Override
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(ModPacketContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        AbstractContainerMenu abstractContainerMenu = serverPlayer.containerMenu;
        if (!(abstractContainerMenu instanceof EndlessInventoryMenu)) {
            return;
        }
        EndlessInventoryMenu menu = (EndlessInventoryMenu)abstractContainerMenu;
        if (menu.containerId != this.containerId) {
            return;
        }
        Optional optional = serverPlayer.serverLevel().getRecipeManager().byKey(this.recipeId);
        optional.ifPresent(recipeObj -> {
            if (!(recipeObj.value() instanceof CraftingRecipe)) {
                log.error("[Packet Handle] Jei recipe transfer handler for EIM is handling non-crafting recipe");
                return;
            }
            RecipeHolder craftingRecipe = recipeObj;
            EIMRecipeTranHandler.performServerTransfer(menu, (RecipeHolder<CraftingRecipe>)craftingRecipe, (Player)serverPlayer, this.maxTransfer);
        });
    }

    private static CraftingRecipe resolveCraftingRecipe(Object recipeObj) {
        if (recipeObj instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipeObj;
            return craftingRecipe;
        }
        try {
            Object value = recipeObj.getClass().getMethod("value", new Class[0]).invoke(recipeObj, new Object[0]);
            if (value instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)value;
                return craftingRecipe;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

