/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.neoforge.options;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class StartupConfig {
    public static final StartupConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.BooleanValue ENABLE_VANILLA_RECIPEBOOK_TRANSFER;
    public final ModConfigSpec.BooleanValue ENABLE_JEI_ATTACHED_TRANSFER;

    private StartupConfig(ModConfigSpec.Builder builder) {
        builder.push("mixin");
        this.ENABLE_VANILLA_RECIPEBOOK_TRANSFER = builder.comment("Enable mixins that integrate vanilla Recipe Book transfer with Endless Inventory.").define("vanillaRecipeBookTransfer", true);
        builder.pop();
        builder.push("experimental");
        this.ENABLE_JEI_ATTACHED_TRANSFER = builder.comment("Enable experimental JEI recipe transfer integration with attached Endless Inventory.").define("jeiAttachedRecipeTransfer", false);
        builder.pop();
    }

    public static boolean enableVanillaRecipeBookTransfer() {
        return (Boolean)StartupConfig.CONFIG.ENABLE_VANILLA_RECIPEBOOK_TRANSFER.get();
    }

    public static boolean enableJeiAttachedTransfer() {
        return (Boolean)StartupConfig.CONFIG.ENABLE_JEI_ATTACHED_TRANSFER.get();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(StartupConfig::new);
        CONFIG = (StartupConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

