/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.IPlatform;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.NbtAttachment;
import com.kwwsyk.endinv.common.item.ScreenDebugger;
import com.kwwsyk.endinv.common.item.TestEndInv;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.network.IPacketDistributor;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.options.IServerConfig;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_5321;

public abstract class AbstractModInitializer {
    public static final class_5321<class_2378<PageType>> PAGE_REG_KEY = class_5321.method_29180((class_2960)AbstractModInitializer.withModLocation("display_page"));

    public static class_2960 withModLocation(String id) {
        return class_2960.method_60655((String)"endless_inventory", (String)id);
    }

    protected AbstractModInitializer() {
    }

    protected void init() {
        this.registerItems(this.itemReg());
        this.registerMenuType(this.menuReg());
        this.registerNbtAttachment();
        ModInfo.setServerConfig(this.loadServerConfig());
        ModInfo.setPacketDistributor(this.loadPacketDistributor());
        ModInfo.platformContext = this.loadOtherPlatformSpecific();
    }

    private void registerItems(RegistryCallback<class_1792> method) {
        ModRegistries.Items.testEndInv = method.register("endinv_accessor", () -> new TestEndInv(new class_1792.class_1793()));
        ModRegistries.Items.screenDebugger = method.register("screen_debugger", () -> new ScreenDebugger(new class_1792.class_1793()));
    }

    private void registerMenuType(RegistryCallback<class_3917<?>> method) {
        ModRegistries.Menus.endinvMenuType = method.register("endinv_menu", this.createEndInvMenuType());
    }

    private void registerNbtAttachment() {
        ModRegistries.NbtAttachments.endInvUUID = this.createEndInvUUID("endinv_uuid");
        ModRegistries.NbtAttachments.syncedConfig = this.createSyncedConfig("endinv_settings");
    }

    protected abstract IPlatform loadOtherPlatformSpecific();

    protected abstract IPacketDistributor loadPacketDistributor();

    protected abstract IServerConfig loadServerConfig();

    protected abstract RegistryCallback<class_1792> itemReg();

    protected abstract RegistryCallback<class_3917<?>> menuReg();

    protected abstract Supplier<class_3917<EndlessInventoryMenu>> createEndInvMenuType();

    protected abstract NbtAttachment<UUID> createEndInvUUID(String var1);

    protected abstract NbtAttachment<SyncedConfig> createSyncedConfig(String var1);

    @FunctionalInterface
    public static interface RegistryCallback<T> {
        public <R extends T> Supplier<R> register(String var1, Supplier<R> var2);
    }
}

