/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.data;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.data.EndInvCodecStrategy;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class FullCodecStrategy
implements EndInvCodecStrategy {
    @Override
    public boolean canHandle(class_2487 tag) {
        class_2499 list = tag.method_10554("Items", 10);
        return !list.isEmpty() && list.method_10602(0).method_10545("modState");
    }

    @Override
    public void deserializeItems(EndlessInventory endlessInventory, class_2487 nbt, class_7225.class_7874 provider) {
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTag = tagList.method_10602(i);
            Optional<class_1799> stackPre = EndInvCodecStrategy.parse((class_2520)itemTag, provider).filter(it -> !it.method_7960());
            long modState = itemTag.method_10537("modState");
            endlessInventory.updateModState(modState);
            stackPre.ifPresent(itemStack -> itemMap.put(ItemKey.asKey(itemStack), new ItemState(itemStack.method_7947(), modState)));
        }
    }

    @Override
    public class_2487 serializeItems(EndlessInventory endlessInventory, class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        Map<ItemKey, ItemState> itemMap = endlessInventory.getItemMap();
        for (Map.Entry<ItemKey, ItemState> entry : itemMap.entrySet()) {
            class_1799 itemStack = entry.getKey().toStack(entry.getValue().count());
            if (itemStack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10544("modState", entry.getValue().lastModTime());
            nbtTagList.add((Object)EndInvCodecStrategy.saveItem(itemStack, itemTag, provider));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", itemMap.size());
        return nbt;
    }
}

