/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.MenuClickHandler;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3915;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class EndlessInventoryMenu
extends class_1703
implements PageMetaDataManager,
PageQuickMoveHandler.PageQuickMoveOverride {
    private final SourceInventory sourceInventory;
    private final class_8566 craftMatrix = new class_1715((class_1703)this, 3, 3);
    private final class_1731 craftResult = new class_1731();
    private static final int CRAFT_GRID_WIDTH = 3;
    private static final int CRAFT_GRID_HEIGHT = 3;
    private static final int RESULT_SLOT_INDEX = 0;
    private static final int CRAFT_SLOT_START = 1;
    private static final int CRAFT_SLOT_COUNT = 9;
    private static final int CRAFT_SLOT_END = 10;
    private static final int PLAYER_INV_SLOT_COUNT = 27;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INV_START = 10;
    private static final int PLAYER_INV_END = 46;
    public final class_1657 player;
    int quickcraftStatus;
    int quickcraftType;
    Set<class_1735> quickcraftSlots = new HashSet<class_1735>();
    private final class_3915 rowsData = class_3915.method_17403();
    private final class_3915 itemSize = class_3915.method_17403();
    private final class_3915 maxStackSize = class_3915.method_17403();
    private static final int CRAFTING_ROWS = 3;
    private final class_3915 infinityMode = class_3915.method_17403();
    private int displayingPageIndex;
    private String displayingPageId;
    private PageType displayingPageType;
    private int baseRows = 1;
    private int visibleRows = 1;
    private boolean craftingVisible = false;
    public SortType sortType;
    public String searching;
    private boolean reverseSort;

    public static EndlessInventoryMenu createClient(int id, class_1661 playerInv) {
        PageData layout = CachedConfig.resolveLayout(null, true);
        EndlessInventoryMenu ret = new EndlessInventoryMenu(id, playerInv, null);
        ret.init(layout);
        ret.switchPageWithId(layout.pageRegKey());
        ret.buildSlotLayout(playerInv);
        return ret;
    }

    public static class_3908 provide(final int rows) {
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43473();
            }

            @Nullable
            public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                return EndlessInventoryMenu.createServer(id, inventory, player, rows);
            }
        };
    }

    @Nullable
    public static class_1703 createServer(int i, class_1661 inventory, class_1657 player, int rows) {
        EndlessInventory endlessInventory = ServerLevelEndInv.getEndInvForPlayer(player).orElse(null);
        if (endlessInventory == null) {
            return null;
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endlessInventory);
        ret.init(new PageData(rows, 9));
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public static EndlessInventoryMenu createWithTemp(int i, class_1661 inventory, class_1657 player) {
        EndlessInventory endInv = ServerLevelEndInv.TEMP_ENDINV_REG.get((class_3222)player);
        if (endInv == null) {
            throw new IllegalStateException("Try to create tmp menu without tmp EndInv.");
        }
        EndlessInventoryMenu ret = new EndlessInventoryMenu(i, inventory, endInv);
        ret.init(PageData.DEFAULT);
        ret.buildSlotLayout(inventory);
        return ret;
    }

    public EndlessInventoryMenu(int id, class_1661 playerInv, @Nullable EndlessInventory endlessInventory) {
        super(ModRegistries.Menus.getEndInvMenuType(), id);
        this.player = playerInv.field_7546;
        this.sourceInventory = endlessInventory != null ? endlessInventory : CachedSrcInv.INSTANCE;
        PageType initialType = PageTypeRegistry.byId("all_items");
        if (initialType == null && PageTypeRegistry.size() > 0) {
            initialType = PageTypeRegistry.byIndex(0);
        }
        if (initialType == null) {
            initialType = PageType.ALL_ITEMS;
        }
        this.displayingPageType = initialType;
        this.displayingPageId = initialType.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
        this.itemSize.method_17404(endlessInventory != null ? endlessInventory.getItemSize() : 0);
        this.maxStackSize.method_17404(endlessInventory != null ? endlessInventory.getMaxItemStackSize() : Integer.MAX_VALUE);
        this.infinityMode.method_17404(endlessInventory != null && endlessInventory.isInfinityMode() ? 1 : 0);
        this.method_17362(this.rowsData);
        this.method_17362(this.itemSize);
        this.method_17362(this.maxStackSize);
        this.method_17362(this.infinityMode);
    }

    public void applyPageData(PageData pageData) {
        this.init(pageData);
    }

    private void init(PageData pageData) {
        int rows;
        this.baseRows = rows = Math.max(1, pageData.rows());
        this.visibleRows = this.craftingVisible ? Math.max(1, rows - 3) : rows;
        this.rowsData.method_17404(this.visibleRows);
        this.sortType = pageData.sortType();
        this.searching = pageData.search();
        this.reverseSort = pageData.reverseSort();
    }

    private void buildSlotLayout(class_1661 playerInventory) {
        if (!this.field_7761.isEmpty()) {
            return;
        }
        int craftX = 30;
        int craftRowsForPosition = Math.max(1, this.baseRows - 3);
        int craftY = 18 * craftRowsForPosition + 18 + 5;
        int resultX = craftX + 54 + 40;
        int resultY = craftY + 18;
        this.method_7621((class_1735)new CraftingResultSlot(this.player, this.craftMatrix, this.craftResult, 0, resultX, resultY));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.method_7621(new CraftingGridSlot(this.craftMatrix, col + row * 3, craftX + col * 18, craftY + row * 18));
            }
        }
        int invY = 18 * this.baseRows + 31;
        this.addStandardInventorySlots(playerInventory, 8, invY);
    }

    public List<class_1735> getCraftingSlots() {
        return this.field_7761.subList(1, 10);
    }

    public List<class_1735> getPlayerInvSlots() {
        return this.field_7761.subList(10, 46);
    }

    @TestOnly
    public boolean validateSlotStatus() throws IllegalStateException {
        for (class_1735 slot : this.getCraftingSlots()) {
            if (slot instanceof CraftingGridSlot) continue;
            throw new IllegalStateException("getCraftingSlots do not correspond menu's crafter slots.");
        }
        for (class_1735 slot : this.getPlayerInvSlots()) {
            if (slot.field_7871 instanceof class_1661) continue;
            throw new IllegalStateException("getPlayerInvSlots contains slots whose container is not inventory");
        }
        if (!(this.field_7761.get(0) instanceof CraftingGridSlot)) {
            throw new IllegalStateException("the first slot is not Crafter's result slot, check ADD SLOT process");
        }
        return true;
    }

    public boolean isCrafterEnabled() {
        return true;
    }

    public void setCraftingVisible(boolean visible) {
        if (this.craftingVisible == visible) {
            return;
        }
        this.craftingVisible = visible;
        this.visibleRows = visible ? Math.max(1, this.baseRows - 3) : this.baseRows;
        this.rowsData.method_17404(this.visibleRows);
        if (!visible) {
            this.returnCraftingToPlayer();
        }
    }

    private void returnCraftingToPlayer() {
        if (this.player.method_37908().field_9236) {
            return;
        }
        class_1661 inventory = this.player.method_31548();
        for (int i = 0; i < this.craftMatrix.method_5439(); ++i) {
            class_1799 stack = this.craftMatrix.method_5441(i);
            if (stack.method_7960()) continue;
            inventory.method_7398(stack);
        }
        this.craftResult.method_5441(0);
        this.craftMatrix.method_5431();
        this.craftResult.method_5431();
    }

    public void method_7609(class_1263 container) {
        if (container == this.craftMatrix) {
            this.updateCraftingResult();
        }
        super.method_7609(container);
    }

    public boolean isCraftingVisible() {
        return this.craftingVisible;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public int getBaseRows() {
        return this.baseRows;
    }

    private void addStandardInventorySlots(class_1661 playerInventory, int x, int y) {
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.method_7621(new class_1735((class_1263)playerInventory, j1 + l * 9 + 9, x + j1 * 18, y + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.method_7621(new class_1735((class_1263)playerInventory, i1, x + i1 * 18, y + 58));
        }
    }

    @Override
    public void switchPageWithIndex(int index) {
        if (index < 0 || index >= PageTypeRegistry.size()) {
            return;
        }
        PageType type = PageTypeRegistry.byIndex(index);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    private void applySelectedPage(PageType type) {
        this.displayingPageType = type;
        this.displayingPageId = type.registerName;
        this.displayingPageIndex = Math.max(0, PageTypeRegistry.getIndexOf(this.displayingPageId));
    }

    @Override
    public int getItemSize() {
        return this.itemSize.method_17407();
    }

    public void setItemSize(int i) {
        this.itemSize.method_17404(i);
    }

    @Override
    public boolean enableInfinity() {
        return this.infinityMode.method_17407() > 0;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStackSize.method_17407();
    }

    @Override
    public class_1703 getMenu() {
        return this;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.sourceInventory;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public int rows() {
        return this.visibleRows;
    }

    @Override
    public int columns() {
        return 9;
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        try {
            if (clickType == class_1713.field_7789) {
                MenuClickHandler.handleQuickCraft(this, slotId, button, player);
            } else if (this.quickcraftStatus != 0) {
                this.method_7605();
            }
            switch (clickType) {
                case field_7790: {
                    MenuClickHandler.handlePickup(this, slotId, button, player);
                    break;
                }
                case field_7794: {
                    MenuClickHandler.handleQuickMove(this, slotId, button, player);
                    break;
                }
                case field_7791: {
                    MenuClickHandler.handleSwap(this, slotId, button, player);
                    break;
                }
                case field_7795: {
                    MenuClickHandler.handleThrow(this, slotId, button, player);
                    break;
                }
                case field_7796: {
                    MenuClickHandler.handleClone(this, slotId, button, player);
                    break;
                }
                case field_7793: {
                    this.handlePickupAll(slotId, button, player);
                    break;
                }
                default: {
                    return;
                }
            }
            SourceInventory sourceInventory = this.getSourceInventory();
            if (sourceInventory instanceof EndlessInventory) {
                EndlessInventory endinv = (EndlessInventory)sourceInventory;
                this.setItemSize(endinv.getItemSize());
            }
        }
        catch (Exception exception) {
            class_128 crashreport = class_128.method_560((Throwable)exception, (String)"Container click");
            class_129 crashreportcategory = crashreport.method_562("Click info");
            crashreportcategory.method_578("Menu Type", (Object)"endless_inventory");
            crashreportcategory.method_577("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportcategory.method_578("Slot Count", (Object)this.field_7761.size());
            crashreportcategory.method_578("Slot", (Object)slotId);
            crashreportcategory.method_578("Button", (Object)button);
            crashreportcategory.method_578("Type", (Object)clickType);
            throw new class_148(crashreport);
        }
    }

    boolean tryItemClickBehaviourOverride(class_1657 player, class_5536 action, class_1735 slot, class_1799 clickedItem, class_1799 carriedItem) {
        if (ModInfo.platformContext.onItemStackedOn(clickedItem, carriedItem, slot, action, player, this.createCarriedSlotAccess())) {
            return true;
        }
        class_7699 featureflagset = player.method_37908().method_45162();
        return carriedItem.method_45435(featureflagset) && carriedItem.method_31575(slot, action, player) || clickedItem.method_45435(featureflagset) && clickedItem.method_31576(carriedItem, slot, action, player, this.createCarriedSlotAccess());
    }

    private class_5630 createCarriedSlotAccess() {
        return new class_5630(){

            public class_1799 method_32327() {
                return EndlessInventoryMenu.this.method_34255();
            }

            public boolean method_32332(class_1799 itemStack) {
                EndlessInventoryMenu.this.method_34254(itemStack);
                return true;
            }
        };
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 slotStack = slot.method_7677();
        if (slotStack.method_7909() == ModRegistries.Items.getTestEndInv()) {
            return class_1799.field_8037;
        }
        class_1799 original = slotStack.method_7972();
        boolean handled = index == 0 ? this.handleQuickMoveResult(slot, slotStack, original) : (this.isCrafterSlot(index) ? this.handleQuickMoveFromCrafterSlot(slot, slotStack) : (this.isPlayerInventorySlot(index) ? this.handleQuickMoveFromPlayerInventory(slotStack) : this.method_7616(slotStack, 10, 46, false)));
        if (!handled) {
            return class_1799.field_8037;
        }
        if (slotStack.method_7960()) {
            slot.method_53512(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        if (slotStack.method_7947() == original.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, slotStack);
        if (index == 0) {
            player.method_7328(slotStack, false);
        }
        return original;
    }

    private boolean isPlayerInventorySlot(int index) {
        return index >= 10 && index < 46;
    }

    private boolean isCrafterSlot(int index) {
        return index >= 1 && index < 10;
    }

    private boolean handleQuickMoveFromCrafterSlot(class_1735 slot, class_1799 stack) {
        boolean moved = this.method_7616(stack, 10, 46, false);
        if (moved) {
            this.craftMatrix.method_5431();
            this.updateCraftingResult();
        }
        return moved;
    }

    private boolean moveStackIntoCrafter(class_1799 stack) {
        int before = stack.method_7947();
        boolean moved = this.method_7616(stack, 1, 10, false);
        if (!moved || stack.method_7947() == before) {
            return false;
        }
        this.craftMatrix.method_5431();
        this.updateCraftingResult();
        return true;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (slot.field_7871 == this.craftResult) {
            return false;
        }
        return super.method_7613(stack, slot);
    }

    private class_1799 quickMoveIntoPage(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remain = this.sourceInventory.addItem(stack);
        this.sourceInventory.setChanged();
        return remain;
    }

    private void handlePickupAll(int slotId, int button, class_1657 player) {
        if (slotId < 0) {
            return;
        }
        class_1735 clickedSlot = (class_1735)this.field_7761.get(slotId);
        class_1799 carried = this.method_34255();
        if (carried.method_7960()) {
            return;
        }
        if (!clickedSlot.method_7681() || !clickedSlot.method_7674(player)) {
            int startIndex = button == 0 ? 0 : this.field_7761.size() - 1;
            int step = button == 0 ? 1 : -1;
            for (int pass = 0; pass < 2; ++pass) {
                for (int index = startIndex; index >= 0 && index < this.field_7761.size() && carried.method_7947() < carried.method_7914(); index += step) {
                    class_1735 scanningSlot = (class_1735)this.field_7761.get(index);
                    if (!class_1703.method_7592((class_1735)scanningSlot, (class_1799)carried, (boolean)true) || !scanningSlot.method_7674(player) || !this.method_7613(carried, scanningSlot)) continue;
                    class_1799 scanningItem = scanningSlot.method_7677();
                    if (pass == 0 && scanningItem.method_7947() == scanningItem.method_7914()) continue;
                    class_1799 taken = scanningSlot.method_32753(scanningItem.method_7947(), carried.method_7914() - carried.method_7947(), player);
                    carried.method_7933(taken.method_7947());
                }
                if (carried.method_7947() >= carried.method_7914()) continue;
                class_1799 extracted = this.tryExtractFromPage(carried, carried.method_7914() - carried.method_7947());
                carried.method_7933(extracted.method_7947());
                carried.method_7939(Math.min(carried.method_7947(), carried.method_7914()));
            }
        }
    }

    public class_1799 tryExtractFromPage(class_1799 template, int count) {
        if (count <= 0 || template.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 request = template.method_7972();
        return this.sourceInventory.takeItem(request, count);
    }

    @Override
    public class_1799 quickMoveFromPage(class_1799 stack) {
        boolean movedToMain;
        boolean crafterAccepted;
        if (stack.method_7960()) {
            return stack;
        }
        boolean bl = crafterAccepted = this.craftingVisible && this.moveStackIntoCrafter(stack);
        if (!stack.method_7960() && !(movedToMain = this.method_7616(stack, 10, 37, false))) {
            this.method_7616(stack, 37, 46, false);
        }
        return crafterAccepted && stack.method_7960() ? class_1799.field_8037 : stack;
    }

    @Override
    public SortType sortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public boolean isSortReversed() {
        return this.reverseSort;
    }

    @Override
    public void switchSortReversed() {
        this.reverseSort = !this.reverseSort;
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.reverseSort = reversed;
    }

    @Override
    public String searching() {
        return this.searching;
    }

    @Override
    public void setSearching(String searching) {
        this.searching = searching;
    }

    @Override
    public PageData getPageData() {
        return new PageData(this.getDisplayingPageId(), this.baseRows, this.columns(), this.sortType(), this.isSortReversed(), this.searching());
    }

    @Override
    public void sendEndInvData() {
        SourceInventory sourceInventory = this.sourceInventory;
        if (sourceInventory instanceof EndlessInventory) {
            EndlessInventory endlessInventory = (EndlessInventory)sourceInventory;
            this.itemSize.method_17404(endlessInventory.getItemSize());
            this.maxStackSize.method_17404(endlessInventory.getMaxItemStackSize());
            this.infinityMode.method_17404(endlessInventory.isInfinityMode() ? 1 : 0);
        }
    }

    @Override
    public String getDisplayingPageId() {
        return this.displayingPageId;
    }

    @Override
    public void switchPageWithId(String id) {
        PageType type = PageTypeRegistry.byId(id);
        if (type != null) {
            this.applySelectedPage(type);
        }
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.displayingPageType;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.returnCraftingToPlayer();
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    private int insertStackIntoPage(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        class_1799 attempt = stack.method_7972();
        class_1799 remainder = this.quickMoveIntoPage(attempt);
        int inserted = stack.method_7947() - remainder.method_7947();
        if (inserted > 0) {
            stack.method_7934(inserted);
        }
        return inserted;
    }

    private boolean handleQuickMoveResult(class_1735 slot, class_1799 stack, class_1799 original) {
        boolean moved;
        boolean bl = moved = this.method_7616(stack, 10, 46, true) || this.method_7616(stack, 10, 46, false);
        if (!moved) {
            this.insertStackIntoPage(stack);
        }
        slot.method_7670(stack, original);
        this.updateCraftingResult();
        return true;
    }

    private boolean handleQuickMoveFromPlayerInventory(class_1799 stack) {
        if (this.craftingVisible) {
            return this.moveStackIntoCrafter(stack);
        }
        return this.insertStackIntoPage(stack) > 0;
    }

    private void updateCraftingResult() {
        class_1657 class_16572 = this.player;
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        class_1937 level = serverPlayer.method_37908();
        class_1799 resultStack = class_1799.field_8037;
        int w = 3;
        int h = 3;
        class_2371 items = class_2371.method_10213((int)(w * h), (Object)class_1799.field_8037);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int idx = y * w + x;
                items.set(idx, (Object)this.craftMatrix.method_5438(idx));
            }
        }
        class_9694 input = class_9694.method_59986((int)w, (int)h, (List)items);
        Optional optional = serverPlayer.field_13995.method_3772().method_8132(class_3956.field_17545, (class_9695)input, level);
        if (optional.isPresent()) {
            class_1799 assembled;
            class_8786 holder = (class_8786)optional.get();
            class_3955 recipe = (class_3955)holder.comp_1933();
            if (this.craftResult.method_7665(level, serverPlayer, holder) && (assembled = recipe.method_8116((class_9695)input, (class_7225.class_7874)level.method_30349())).method_45435(level.method_45162())) {
                resultStack = assembled;
            }
        }
        this.craftResult.method_5447(0, resultStack);
        this.method_34245(0, resultStack);
        serverPlayer.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), 0, resultStack));
    }

    private class CraftingResultSlot
    extends class_1734 {
        CraftingResultSlot(class_1657 player, class_8566 matrix, class_1731 result, int slotIndex, int x, int y) {
            super(player, matrix, (class_1263)result, slotIndex, x, y);
        }

        public boolean method_7682() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    private class CraftingGridSlot
    extends class_1735 {
        CraftingGridSlot(class_8566 matrix, int slot, int x, int y) {
            super((class_1263)matrix, slot, x, y);
        }

        public boolean method_7682() {
            return EndlessInventoryMenu.this.craftingVisible;
        }
    }

    public static interface ClientPageBinding {
        public String pageId();

        public PageType pageType();

        public void onPageSelected();

        public void scrollTo(float var1);

        public class_1799 quickMoveIntoPage(class_1799 var1);

        public void markPageChanged();

        public class_1799 extractItemFromPage(class_1799 var1, int var2);

        public void refreshAfterMenuInteraction(SourceInventory var1);
    }
}

