/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.menu.page.pageManager;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageMetaDataManager;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.IPacketDistributor;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvContent;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.network.payloads.toClient.SetItemDisplayContentPayload;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.common.util.SortType;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;

public class AttachingMonitor
implements PageMetaDataManager {
    private final class_1703 menu;
    private final EndlessInventory endinv;
    private final class_3222 player;
    private final List<String> PageIdList;
    private final List<PageType> pageTypeList;
    private String DisplayingPageId;
    private int displayingPageIndex;
    private final PageQuickMoveHandler quickMoveHandler;
    public SortType sortType;
    public String searching;
    private int rows;
    private int columns;
    private boolean reverseSort;

    public AttachingMonitor(class_1703 menu, EndlessInventory endinv, class_3222 player) {
        this.menu = menu;
        this.endinv = endinv;
        this.player = player;
        this.pageTypeList = PageTypeRegistry.getDisplayPages();
        this.PageIdList = this.pageTypeList.stream().map(tp -> tp.registerName).toList();
        this.rows = 9;
        this.columns = 9;
        this.sortType = SortType.DEFAULT;
        this.searching = "";
        this.reverseSort = false;
        if (!this.PageIdList.isEmpty()) {
            this.displayingPageIndex = 0;
            this.DisplayingPageId = this.PageIdList.get(0);
        } else {
            this.displayingPageIndex = 0;
            this.DisplayingPageId = "all_items";
        }
        this.quickMoveHandler = new PageQuickMoveHandler(this);
    }

    public void applyPageData(PageData data) {
        this.rows = data.rows();
        this.columns = data.columns();
        this.sortType = data.sortType();
        this.searching = data.search();
        this.reverseSort = data.reverseSort();
        this.switchPageWithId(data.pageRegKey());
    }

    @Override
    public class_1703 getMenu() {
        return this.menu;
    }

    @Override
    public SourceInventory getSourceInventory() {
        return this.endinv;
    }

    @Override
    public void switchPageWithIndex(int index) {
        this.displayingPageIndex = index;
        this.DisplayingPageId = this.PageIdList.get(index);
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public int getItemSize() {
        return this.endinv.getItemSize();
    }

    @Override
    public int getMaxStackSize() {
        return this.endinv.getMaxItemStackSize();
    }

    @Override
    public boolean enableInfinity() {
        return this.endinv.isInfinityMode();
    }

    @Override
    public class_1799 quickMoveFromPage(class_1799 stack) {
        return this.quickMoveHandler.quickMoveFromPage(stack);
    }

    @Override
    public SortType sortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public boolean isSortReversed() {
        return this.reverseSort;
    }

    @Override
    public void switchSortReversed() {
        this.reverseSort = !this.reverseSort;
    }

    @Override
    public void setSortReversed(boolean reversed) {
        this.reverseSort = reversed;
    }

    @Override
    public String searching() {
        return this.searching;
    }

    @Override
    public void setSearching(String searching) {
        this.searching = searching;
    }

    @Override
    public void sendEndInvData() {
        IPacketDistributor distributor = ModInfo.getPacketDistributor();
        IServerConfig cfg = ModInfo.getServerConfig();
        distributor.sendToPlayer(this.player, EndInvMetadata.getWith(this.endinv));
        switch (cfg.transferMode().get()) {
            case ALL: {
                distributor.sendToPlayer(this.player, new EndInvContent(this.endinv.getItemMap()));
                break;
            }
            case PART: {
                int length = this.rows * this.columns;
                List<class_1799> view = this.endinv.getSortedAndFilteredItemView(0, length, this.sortType, this.reverseSort, this.getDisplayingPageType().itemClassify, this.searching);
                class_2371 stacks = class_2371.method_10213((int)length, (Object)class_1799.field_8037);
                for (int i = 0; i < view.size() && i < length; ++i) {
                    stacks.set(i, (Object)view.get(i));
                }
                distributor.sendToPlayer(this.player, new SetItemDisplayContentPayload((List<class_1799>)stacks));
            }
        }
    }

    @Override
    public void switchPageWithId(String id) {
        this.DisplayingPageId = id;
        for (int i = 0; i < this.PageIdList.size(); ++i) {
            if (!this.PageIdList.get(i).equals(id)) continue;
            this.displayingPageIndex = i;
        }
    }

    @Override
    public String getDisplayingPageId() {
        return this.DisplayingPageId;
    }

    @Override
    public PageType getDisplayingPageType() {
        return this.pageTypeList.get(this.displayingPageIndex);
    }
}

