/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.slf4j.Logger;

public record ItemClickPayload(class_1799 stack, int button, class_1713 clickType) implements ModPacketPayload
{
    public static final class_9139<class_9129, ItemClickPayload> STREAM_CODEC = class_9139.method_56437((buf, value) -> ItemClickPayload.encode(value, buf), ItemClickPayload::decode);
    public static final class_8710.class_9154<ItemClickPayload> TYPE = new class_8710.class_9154(AbstractModInitializer.withModLocation("item_click"));
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemClickPayload decode(class_9129 buf) {
        return new ItemClickPayload((class_1799)class_1799.field_49268.decode((Object)buf), buf.readInt(), (class_1713)buf.method_10818(class_1713.class));
    }

    public static void encode(ItemClickPayload itemClickPayload, class_9129 o) {
        class_1799.field_49268.encode((Object)o, (Object)itemClickPayload.stack);
        o.method_53002(itemClickPayload.button);
        o.method_10817((Enum)itemClickPayload.clickType);
    }

    @Override
    public void handle(ModPacketContext context) {
        class_1657 player = context.player();
        class_1703 menu = player.field_7512;
        class_1799 carried = menu.method_34255();
        LOGGER.debug("EI:ItemClickPayload.handle: player={} clickType={} button={} carriedEmpty={} stack={}", new Object[]{player.method_5477().getString(), this.clickType, this.button, carried.method_7960(), this.stack});
        Optional<EndlessInventory> opt = ServerLevelEndInv.getEndInvForPlayer(player);
        if (opt.isEmpty()) {
            LOGGER.warn("ItemClickPayload.handle: no EndInv for player={}", (Object)player.method_5477().getString());
            return;
        }
        EndlessInventory endInv = opt.get();
        block0 : switch (this.clickType) {
            case field_7790: {
                if (!carried.method_7960()) {
                    class_1799 remain = endInv.addItem(carried);
                    menu.method_34254(remain);
                    endInv.setChanged();
                    break;
                }
                int count = Math.min(this.stack.method_7947(), this.stack.method_7914());
                int takenCount = this.button == 0 ? count : (count + 1) / 2;
                class_1799 taken = endInv.takeItem(this.stack, takenCount);
                LOGGER.debug("ItemClickPayload.PICKUP: taken={} from stack={}", (Object)taken, (Object)this.stack);
                if (player.method_7337() && menu instanceof class_1723) {
                    LOGGER.info("Ignored taken item on server thread in Creative mode to prevent duplication.");
                } else {
                    menu.method_34254(taken);
                }
                if (this.stack.method_7960()) break;
                endInv.setChanged();
                break;
            }
            case field_7791: {
                class_1799 remain;
                class_1661 inventory = player.method_31548();
                class_1799 inventoryItem = inventory.method_5438(this.button);
                boolean a = !inventoryItem.method_7960();
                boolean b = !this.stack.method_7960();
                LOGGER.debug("ItemClickPayload.SWAP: inventoryItem={} clickedStack={}", (Object)inventoryItem, (Object)this.stack);
                if (a && !b) {
                    remain = endInv.addItem(inventoryItem);
                    inventory.method_5447(this.button, remain);
                    LOGGER.debug("ItemClickPayload.SWAP: added inventoryItem, remain={}", (Object)remain);
                }
                if (!a && b) {
                    class_1799 swapping = endInv.takeItem(this.stack);
                    inventory.method_5447(this.button, swapping);
                    LOGGER.debug("ItemClickPayload.SWAP: took from endInv swapping={}", (Object)swapping);
                }
                if (a && b) {
                    remain = endInv.addItem(inventoryItem);
                    LOGGER.debug("ItemClickPayload.SWAP: both non-empty, remainFromAdd={}", (Object)remain);
                    if (remain.method_7960()) {
                        class_1799 swapping = endInv.takeItem(this.stack);
                        inventory.method_5447(this.button, swapping);
                        LOGGER.debug("ItemClickPayload.SWAP: swap success swapping={}", (Object)swapping);
                    } else {
                        inventory.method_5447(this.button, remain);
                    }
                }
                endInv.setChanged();
                break;
            }
            case field_7795: {
                class_1799 thrown = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.THROW: thrown={}", (Object)thrown);
                player.method_7328(thrown, true);
                endInv.setChanged();
                break;
            }
            case field_7793: {
                int startIndex;
                for (int index = startIndex = menu.field_7761.size() - 1; index >= 0; --index) {
                    class_1735 scanning = (class_1735)menu.field_7761.get(index);
                    if (!(scanning.field_7871 instanceof class_1661)) break block0;
                    class_1799 scanningItem = scanning.method_7677();
                    if (!class_1799.method_31577((class_1799)carried, (class_1799)scanningItem)) continue;
                    class_1799 taken = scanning.method_32753(scanningItem.method_7947(), scanningItem.method_7947(), player);
                    LOGGER.debug("ItemClickPayload.PICKUP_ALL: took {} from slot index={}", (Object)taken, (Object)index);
                    class_1799 remain = endInv.addItem(taken);
                    if (!remain.method_7960()) {
                        scanning.method_7673(remain);
                    }
                    endInv.setChanged();
                }
                break;
            }
            case field_7796: {
                if (!player.method_7337() || !carried.method_7960()) break;
                menu.method_34254(this.stack.method_46651(this.stack.method_7914()));
                LOGGER.debug("ItemClickPayload.CLONE: cloned stack={}", (Object)this.stack);
                break;
            }
            case field_7794: {
                class_1799 taken = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: taken={}", (Object)taken);
                class_1799 remain = new PageQuickMoveHandler(menu).quickMoveFromPage(taken);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: remain after quickMove={}", (Object)remain);
                endInv.addItem(remain);
                endInv.setChanged();
            }
        }
    }

    @Override
    public String id() {
        return "item_click";
    }

    @Override
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

