/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.IPlatform;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.NbtAttachment;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.network.IPacketDistributor;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.options.IServerConfig;
import com.kwwsyk.endinv.fabric.FabricPacketDistributor;
import com.kwwsyk.endinv.fabric.ServerConfig;
import com.kwwsyk.endinv.fabric.event.FabricEvents;
import com.kwwsyk.endinv.fabric.integrates.clothconfig.ClothConfigIntegration;
import com.kwwsyk.endinv.fabric.nbtAttachment.AttachingCapabilities;
import com.kwwsyk.endinv.fabric.nbtAttachment.FabricNbtStorage;
import com.kwwsyk.endinv.fabric.network.FabricNetworking;
import com.kwwsyk.endinv.fabric.network.FabricServerNetworking;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7923;
import org.slf4j.LoggerFactory;

public class ModInit
extends AbstractModInitializer
implements ModInitializer {
    public void onInitialize() {
        FabricNetworking.init();
        FabricServerNetworking.init();
        FabricEvents.init();
        super.init();
        AttachingCapabilities.register();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && FabricLoader.getInstance().isModLoaded("cloth-config2")) {
            ClothConfigIntegration.register();
        }
    }

    @Override
    protected IPlatform loadOtherPlatformSpecific() {
        return (clickedItem, carriedItem, slot, action, player, access) -> {
            class_7699 features = player.method_37908().method_45162();
            return carriedItem.method_45435(features) && carriedItem.method_31575(slot, action, player) || clickedItem.method_45435(features) && clickedItem.method_31576(carriedItem, slot, action, player, access);
        };
    }

    @Override
    protected IPacketDistributor loadPacketDistributor() {
        return new FabricPacketDistributor();
    }

    @Override
    protected IServerConfig loadServerConfig() {
        return ServerConfig.INSTANCE;
    }

    @Override
    protected AbstractModInitializer.RegistryCallback<class_1792> itemReg() {
        return new AbstractModInitializer.RegistryCallback<class_1792>(this){

            @Override
            public <R extends class_1792> Supplier<R> register(String id, Supplier<R> supplier) {
                class_2960 location = AbstractModInitializer.withModLocation(id);
                class_1792 item = (class_1792)supplier.get();
                class_1792 registered = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)location, (Object)item);
                return () -> registered;
            }
        };
    }

    @Override
    protected AbstractModInitializer.RegistryCallback<class_3917<?>> menuReg() {
        return new AbstractModInitializer.RegistryCallback<class_3917<?>>(this){

            @Override
            public <R extends class_3917<?>> Supplier<R> register(String id, Supplier<R> supplier) {
                class_2960 location = AbstractModInitializer.withModLocation(id);
                class_3917 type = (class_3917)supplier.get();
                class_3917 registered = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)location, (Object)type);
                return () -> registered;
            }
        };
    }

    @Override
    protected Supplier<class_3917<EndlessInventoryMenu>> createEndInvMenuType() {
        return () -> {
            class_3917 raw = new class_3917((id, inventory) -> {
                try {
                    Class<?> cls = Class.forName("com.kwwsyk.endinv.common.menu.EndlessInventoryMenu");
                    Method m = cls.getMethod("createClient", Integer.TYPE, class_1661.class);
                    Object menu = m.invoke(null, id, inventory);
                    return (class_1703)menu;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }, class_7701.field_40183);
            return raw;
        };
    }

    @Override
    protected NbtAttachment<UUID> createEndInvUUID(String name) {
        return new NbtAttachment<UUID>(this){

            @Override
            public UUID getWith(class_1657 player) {
                UUID uuid = FabricNbtStorage.getUuid(player);
                return uuid != null ? uuid : ModInfo.DEFAULT_UUID;
            }

            @Override
            public void setTo(class_1657 player, UUID uuid) {
                FabricNbtStorage.setUuid(player, uuid);
            }

            @Override
            public UUID computeIfAbsent(class_1657 player) {
                UUID uuid = FabricNbtStorage.getUuid(player);
                if (uuid == null) {
                    FabricNbtStorage.setUuid(player, ModInfo.DEFAULT_UUID);
                    return ModInfo.DEFAULT_UUID;
                }
                return uuid;
            }
        };
    }

    @Override
    protected NbtAttachment<SyncedConfig> createSyncedConfig(final String name) {
        return new NbtAttachment<SyncedConfig>(this){

            @Override
            public SyncedConfig getWith(class_1657 player) {
                if (!FabricNbtStorage.hasCompound(player, name)) {
                    return SyncedConfig.DEFAULT;
                }
                class_2487 compound = FabricNbtStorage.getCompound(player, name).method_10553();
                return SyncedConfig.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)compound).resultOrPartial(ModInit::logCodecError).orElse(SyncedConfig.DEFAULT);
            }

            @Override
            public void setTo(class_1657 player, SyncedConfig syncedConfig) {
                SyncedConfig.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)syncedConfig).resultOrPartial(ModInit::logCodecError).ifPresent(tag -> {
                    if (tag instanceof class_2487) {
                        class_2487 compound = (class_2487)tag;
                        FabricNbtStorage.setCompound(player, name, compound.method_10553());
                    }
                });
            }

            @Override
            public SyncedConfig computeIfAbsent(class_1657 player) {
                SyncedConfig config = this.getWith(player);
                if (config == SyncedConfig.DEFAULT) {
                    this.setTo(player, SyncedConfig.DEFAULT);
                }
                return this.getWith(player);
            }
        };
    }

    private static void logCodecError(String message) {
        LoggerFactory.getLogger(ModInit.class).warn("Failed to process synced config: {}", (Object)message);
    }
}

