/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui.page;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.client.gui.EndlessInventoryScreen;
import com.kwwsyk.endinv.common.client.gui.page.DisplayPage;
import com.kwwsyk.endinv.common.client.gui.page.manager.PageManager;
import com.kwwsyk.endinv.common.client.option.CachedConfig;
import com.kwwsyk.endinv.common.menu.page.PageType;
import com.kwwsyk.endinv.common.network.payloads.PageData;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ItemPage
extends DisplayPage {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected NonNullList<ItemStack> items;
    protected int startIndex = 0;
    protected int length = this.meta.rows() * this.meta.columns();
    protected List<ItemStack> inQueueStacks = null;

    public ItemPage(PageType pageType, PageManager manager) {
        super(pageType, manager);
    }

    @Override
    public void resize(int rows) {
        int targetRows = Math.max(1, rows);
        this.length = targetRows * this.meta.columns();
        this.initializeContents(this.startIndex, this.length);
    }

    @Override
    public void scrollTo(float pos) {
        int startIndex = this.getRowIndexForScroll(pos) * this.meta.columns();
        this.initializeContents(startIndex, this.length);
    }

    @Override
    public void initializeContents() {
        this.initializeContents(0, this.meta.rows() * this.meta.columns());
    }

    protected void initializeContents(int startIndex, int length) {
        this.startIndex = startIndex;
        this.length = Math.min(length, this.meta.rows() * this.meta.columns());
        if (this.items == null || this.items.size() != this.length) {
            this.items = NonNullList.m_122780_((int)this.length, (Object)ItemStack.f_41583_);
        }
        if (length != this.items.size()) {
            this.items = NonNullList.m_122780_((int)length, (Object)ItemStack.f_41583_);
        }
        this.release();
        this.refreshItems();
    }

    public abstract void refreshItems();

    public abstract void requestRemoteContents();

    @Override
    public void sendChangesToServer() {
        PageData layout = CachedConfig.currentLayout();
        ModInfo.getPacketDistributor().sendToServer(new ItemPageContext(this.startIndex, this.length, layout));
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public boolean canScroll() {
        return this.startIndex > 0 || this.startIndex + this.length <= this.srcInv.getItemSize();
    }

    @Override
    public int getSlotByMouseOffset(double XOffset, double YOffset) {
        if (XOffset < 0.0 || YOffset < 0.0 || XOffset > (double)(18 * this.meta.columns()) || YOffset > (double)(18 * this.meta.rows())) {
            return -1;
        }
        return (int)XOffset / 18 + this.meta.columns() * ((int)YOffset / 18);
    }

    @Override
    public Rect2i getOneInteractableArea(double XOffset, double YOffset) {
        return this.getSlotArea(this.getSlotByMouseOffset(XOffset, YOffset));
    }

    @Nullable
    public Rect2i getSlotArea(int slot) {
        if (slot < 0) {
            return null;
        }
        int slotSize = 18;
        int rowAt = slot / this.meta.columns();
        int columnAt = slot % this.meta.columns();
        return new Rect2i(this.leftPos + 18 * columnAt, this.topPos + 18 * rowAt, 18, 18);
    }

    @Override
    public ItemStack getItemByMouseOffset(double XOffset, double YOffset) {
        int slot = this.getSlotByMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            return (ItemStack)this.items.get(slot);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void handleStarItem(double XOffset, double YOffset) {
        ItemStack clicked = this.getItemByMouseOffset(XOffset, YOffset);
        if (clicked.m_41619_()) {
            return;
        }
        ModInfo.getPacketDistributor().sendToServer(new StarItemPayload(clicked, true));
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int rowIndex = 0;
        int columnIndex = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_() && !stack.m_150930_(Items.f_41852_)) {
                this.renderEmpty(guiGraphics, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, stack);
            }
            guiGraphics.m_280256_(stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, columnIndex + rowIndex * 180);
            if (!this.isHiddenBySortBox(rowIndex, columnIndex)) {
                guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, stack, this.leftPos + columnIndex * 18, this.topPos + rowIndex * 18 + 1, this.getDisplayAmount(stack));
            }
            if (++columnIndex < this.meta.columns()) continue;
            columnIndex = 0;
            ++rowIndex;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderEmpty(GuiGraphics guiGraphics, int x, int y, ItemStack itemStack) {
        ItemStack toRender = itemStack.m_255036_(1);
        guiGraphics.m_280256_(toRender, x, y, 0);
        guiGraphics.m_280302_(Minecraft.m_91087_().f_91062_, toRender, x, y, ChatFormatting.RED + "0");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isHiddenBySortBox(int rowIndex, int columnIndex) {
        if (rowIndex > 2) return false;
        if (columnIndex > 3) return false;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (!(screen instanceof AbstractContainerScreen)) return false;
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        if (screen2 instanceof EndlessInventoryScreen) {
            EndlessInventoryScreen EIS = (EndlessInventoryScreen)screen2;
            if (EIS.getFrameWork().sortTypeSwitchBox.isOpen()) {
                if (columnIndex <= 2) return true;
            }
        }
        if (!this.framework.sortTypeSwitchBox.isOpen()) return false;
        return true;
    }

    protected String getDisplayAmount(ItemStack stack) {
        String suffix;
        double value;
        int count = stack.m_41613_();
        if (count == this.meta.getMaxStackSize() && this.meta.enableInfinity()) {
            return "\u221e";
        }
        if (count >= 1000000000) {
            value = (double)count / 1.0E9;
            suffix = "b";
        } else if (count >= 1000000) {
            value = (double)count / 1000000.0;
            suffix = "m";
        } else if (count >= 1000) {
            value = (double)count / 1000.0;
            suffix = "k";
        } else {
            if (count == 0) {
                return ChatFormatting.RED + "0";
            }
            return String.valueOf(count);
        }
        return String.format("%.1f%s", value, suffix);
    }

    @Override
    public void renderHovering(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderSlotHighlight(graphics, mouseX, mouseY, partialTick);
        ItemStack hovering = this.getHoveredOrClickedItem(mouseX, mouseY);
        if (hovering.m_41619_()) {
            return;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 550.0f);
        graphics.m_280677_(Minecraft.m_91087_().f_91062_, AbstractContainerScreen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)hovering), hovering.m_150921_(), mouseX, mouseY);
        graphics.m_280168_().m_85849_();
    }

    protected void renderSlotHighlight(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int u = 0; u < this.meta.columns(); ++u) {
            for (int v = 0; v < this.meta.rows(); ++v) {
                int x1 = this.leftPos + 18 * u - 1;
                int x2 = this.leftPos + 18 * u + 16;
                int y1 = this.topPos + 18 * v + 1;
                int y2 = this.topPos + 18 * v + 18;
                if (mouseX <= x1 || mouseX >= x2 || mouseY <= y1 || mouseY >= y2) continue;
                if (!this.meta.getMenu().m_142621_().m_41619_()) {
                    return;
                }
                graphics.m_285978_(RenderType.m_286086_(), x1, y1, x2, y2, -2130706433, -2130706433, 0);
            }
        }
    }

    @Override
    public boolean doubleClickedOnOne(double XOffset, double YOffset, double lastX, double lastY, long clickInterval) {
        return this.clickedInOneSlot(XOffset, YOffset, lastX, lastY) && clickInterval <= 250L;
    }

    protected boolean clickedInOneSlot(double XOffset, double YOffset, double lastX, double lastY) {
        return (int)XOffset / 18 == (int)lastX / 18 && (int)YOffset / 18 == (int)lastY / 18;
    }

    @Override
    public void pageClicked(double XOffset, double YOffset, int button, ClickType clickType) {
        int slot = this.getSlotByMouseOffset(XOffset, YOffset);
        if (slot >= 0 && slot < this.items.size()) {
            ItemStack clicked = ((ItemStack)this.items.get(slot)).m_41777_();
            switch (clickType) {
                case PICKUP: {
                    this.handlePickup(clicked, button);
                    break;
                }
                case QUICK_MOVE: {
                    this.handleQuickMove(clicked);
                    break;
                }
                case SWAP: {
                    this.handleSwap(clicked, button);
                    break;
                }
                case THROW: {
                    this.handleThrow(clicked);
                    break;
                }
                case PICKUP_ALL: {
                    this.handlePickupAll(clicked);
                    break;
                }
                case CLONE: {
                    this.handleClone(clicked);
                    break;
                }
            }
            LOGGER.info("EI:sending:ItemClickPayload: player={} clickType={} button={} stack={}", new Object[]{this.meta.getPlayer(), clickType, button, clicked});
            ModInfo.getPacketDistributor().sendToServer(new ItemClickPayload(clicked.m_41613_() > 64 ? clicked.m_255036_(64) : clicked.m_41777_(), button, clickType));
            this.refreshItems();
        }
    }

    public ItemStack takeItem(ItemStack itemStack) {
        return this.takeItem(itemStack, itemStack.m_41741_());
    }

    public ItemStack takeItem(ItemStack itemStack, int count) {
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public ItemStack takeItem(int index, int count) {
        ItemStack itemStack = (ItemStack)this.items.get(index);
        this.setChanged();
        return this.srcInv.takeItem(itemStack, count);
    }

    public ItemStack addItem(ItemStack itemStack) {
        this.setChanged();
        return this.srcInv.addItem(itemStack.m_41777_());
    }

    public boolean isFull(ItemStack itemStack) {
        return itemStack.m_41613_() >= this.meta.getMaxStackSize();
    }

    public boolean isInfinite(ItemStack itemStack) {
        return this.isFull(itemStack) && this.meta.enableInfinity();
    }

    protected void handleQuickMove(ItemStack clicked) {
        ItemStack taken = this.takeItem(clicked);
        ItemStack remain = this.meta.quickMoveFromPage(taken);
        this.addItem(remain);
        this.setChanged();
    }

    @Override
    public ItemStack tryInsertItem(ItemStack stack) {
        ItemStack remain = this.addItem(stack);
        this.initializeContents();
        return remain;
    }

    @Override
    public ItemStack tryExtractItem(ItemStack stack, int count) {
        return this.takeItem(stack, count);
    }

    protected void handlePickup(ItemStack clicked, int keyCode) {
        ItemStack carried = this.meta.getMenu().m_142621_();
        if (!carried.m_41619_()) {
            ItemStack remain = this.addItem(carried.m_41777_());
            if (ModInfo.isClientLoaded() && this.meta.getMenu() instanceof CreativeModeInventoryScreen.ItemPickerMenu) {
                ModInfo.getPacketDistributor().sendToServer(new CreativeItemModPayload(carried.m_41777_(), true));
            }
            this.meta.getMenu().m_142503_(remain);
            this.setChanged();
        } else {
            int count = Math.min(clicked.m_41613_(), clicked.m_41741_());
            int takenCount = keyCode == 0 ? count : (count + 1) / 2;
            this.meta.getMenu().m_142503_(this.takeItem(clicked, takenCount));
            if (!this.meta.getMenu().m_142621_().m_41619_()) {
                this.setChanged();
            }
        }
    }

    protected void handleSwap(ItemStack clicked, int inventorySlotId) {
        ItemStack remain;
        boolean b;
        Player player = this.meta.getPlayer();
        Inventory inventory = player.m_150109_();
        ItemStack inventoryItem = inventory.m_8020_(inventorySlotId);
        boolean a = !inventoryItem.m_41619_();
        boolean bl = b = !clicked.m_41619_();
        if (a && !b) {
            remain = this.addItem(inventoryItem);
            inventory.m_6836_(inventorySlotId, remain);
        }
        if (!a && b) {
            ItemStack swapping = this.takeItem(clicked);
            inventory.m_6836_(inventorySlotId, swapping);
        }
        if (a && b) {
            remain = this.addItem(inventoryItem);
            if (remain.m_41619_()) {
                ItemStack swapping = this.takeItem(clicked);
                inventory.m_6836_(inventorySlotId, swapping);
            } else {
                inventory.m_6836_(inventorySlotId, remain);
            }
        }
        this.setChanged();
    }

    protected void handleThrow(ItemStack clicked) {
        Player player = this.meta.getPlayer();
        ItemStack thrown = this.takeItem(clicked);
        player.m_36176_(thrown, true);
        this.setChanged();
    }

    protected void handlePickupAll(ItemStack clicked) {
        int startIndex;
        Player player = this.meta.getPlayer();
        ItemStack carried = this.meta.getMenu().m_142621_();
        for (int index = startIndex = this.meta.getMenu().f_38839_.size() - 1; index >= 0; --index) {
            Slot scanning = (Slot)this.meta.getMenu().f_38839_.get(index);
            if (!(scanning.f_40218_ instanceof Inventory)) break;
            ItemStack scanningItem = scanning.m_7993_();
            if (!ItemStack.m_150942_((ItemStack)carried, (ItemStack)scanningItem)) continue;
            ItemStack taken = scanning.m_150647_(scanningItem.m_41613_(), scanningItem.m_41613_(), player);
            ItemStack remain = this.addItem(taken);
            if (!remain.m_41619_()) {
                scanning.m_5852_(remain);
            }
            this.setChanged();
        }
    }

    protected void handleClone(ItemStack clicked) {
        Player player = this.meta.getPlayer();
        if (player.m_150110_().f_35937_ && this.meta.getMenu().m_142621_().m_41619_()) {
            this.meta.getMenu().m_142503_(clicked.m_255036_(clicked.m_41741_()));
        }
    }
}

