/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.page.pageManager.PageQuickMoveHandler;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public record ItemClickPayload(ItemStack stack, int button, ClickType clickType) implements ModPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ItemClickPayload decode(FriendlyByteBuf buf) {
        return new ItemClickPayload(buf.m_130267_(), buf.readInt(), (ClickType)buf.m_130066_(ClickType.class));
    }

    public static void encode(ItemClickPayload itemClickPayload, FriendlyByteBuf o) {
        o.m_130055_(itemClickPayload.stack);
        o.writeInt(itemClickPayload.button);
        o.m_130068_((Enum)itemClickPayload.clickType);
    }

    @Override
    public void handle(ModPacketContext context) {
        Player player = context.player();
        AbstractContainerMenu menu = player.f_36096_;
        ItemStack carried = menu.m_142621_();
        LOGGER.debug("EI:ItemClickPayload.handle: player={} clickType={} button={} carriedEmpty={} stack={}", new Object[]{player.m_7755_().getString(), this.clickType, this.button, carried.m_41619_(), this.stack});
        Optional<EndlessInventory> opt = ServerLevelEndInv.getEndInvForPlayer(player);
        if (opt.isEmpty()) {
            LOGGER.warn("ItemClickPayload.handle: no EndInv for player={}", (Object)player.m_7755_().getString());
            return;
        }
        EndlessInventory endInv = opt.get();
        block0 : switch (this.clickType) {
            case PICKUP: {
                if (!carried.m_41619_()) {
                    ItemStack remain = endInv.addItem(carried);
                    menu.m_142503_(remain);
                    endInv.setChanged();
                    break;
                }
                int count = Math.min(this.stack.m_41613_(), this.stack.m_41741_());
                int takenCount = this.button == 0 ? count : (count + 1) / 2;
                ItemStack taken = endInv.takeItem(this.stack, takenCount);
                LOGGER.debug("ItemClickPayload.PICKUP: taken={} from stack={}", (Object)taken, (Object)this.stack);
                if (player.m_7500_() && menu instanceof InventoryMenu) {
                    LOGGER.info("Ignored taken item on server thread in Creative mode to prevent duplication.");
                } else {
                    menu.m_142503_(taken);
                }
                if (this.stack.m_41619_()) break;
                endInv.setChanged();
                break;
            }
            case SWAP: {
                ItemStack remain;
                Inventory inventory = player.m_150109_();
                ItemStack inventoryItem = inventory.m_8020_(this.button);
                boolean a = !inventoryItem.m_41619_();
                boolean b = !this.stack.m_41619_();
                LOGGER.debug("ItemClickPayload.SWAP: inventoryItem={} clickedStack={}", (Object)inventoryItem, (Object)this.stack);
                if (a && !b) {
                    remain = endInv.addItem(inventoryItem);
                    inventory.m_6836_(this.button, remain);
                    LOGGER.debug("ItemClickPayload.SWAP: added inventoryItem, remain={}", (Object)remain);
                }
                if (!a && b) {
                    ItemStack swapping = endInv.takeItem(this.stack);
                    inventory.m_6836_(this.button, swapping);
                    LOGGER.debug("ItemClickPayload.SWAP: took from endInv swapping={}", (Object)swapping);
                }
                if (a && b) {
                    remain = endInv.addItem(inventoryItem);
                    LOGGER.debug("ItemClickPayload.SWAP: both non-empty, remainFromAdd={}", (Object)remain);
                    if (remain.m_41619_()) {
                        ItemStack swapping = endInv.takeItem(this.stack);
                        inventory.m_6836_(this.button, swapping);
                        LOGGER.debug("ItemClickPayload.SWAP: swap success swapping={}", (Object)swapping);
                    } else {
                        inventory.m_6836_(this.button, remain);
                    }
                }
                endInv.setChanged();
                break;
            }
            case THROW: {
                ItemStack thrown = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.THROW: thrown={}", (Object)thrown);
                player.m_36176_(thrown, true);
                endInv.setChanged();
                break;
            }
            case PICKUP_ALL: {
                int startIndex;
                for (int index = startIndex = menu.f_38839_.size() - 1; index >= 0; --index) {
                    Slot scanning = (Slot)menu.f_38839_.get(index);
                    if (!(scanning.f_40218_ instanceof Inventory)) break block0;
                    ItemStack scanningItem = scanning.m_7993_();
                    if (!ItemStack.m_150942_((ItemStack)carried, (ItemStack)scanningItem)) continue;
                    ItemStack taken = scanning.m_150647_(scanningItem.m_41613_(), scanningItem.m_41613_(), player);
                    LOGGER.debug("ItemClickPayload.PICKUP_ALL: took {} from slot index={}", (Object)taken, (Object)index);
                    ItemStack remain = endInv.addItem(taken);
                    if (!remain.m_41619_()) {
                        scanning.m_5852_(remain);
                    }
                    endInv.setChanged();
                }
                break;
            }
            case CLONE: {
                if (!player.m_7500_() || !carried.m_41619_()) break;
                menu.m_142503_(this.stack.m_255036_(this.stack.m_41741_()));
                LOGGER.debug("ItemClickPayload.CLONE: cloned stack={}", (Object)this.stack);
                break;
            }
            case QUICK_MOVE: {
                ItemStack taken = endInv.takeItem(this.stack);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: taken={}", (Object)taken);
                ItemStack remain = new PageQuickMoveHandler(menu).quickMoveFromPage(taken);
                LOGGER.debug("ItemClickPayload.QUICK_MOVE: remain after quickMove={}", (Object)remain);
                endInv.addItem(remain);
                endInv.setChanged();
            }
        }
    }

    @Override
    public String id() {
        return "item_click";
    }
}

