/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.client.config;

import com.kwwsyk.endinv.common.client.gui.bg.FromResource;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import com.kwwsyk.endinv.common.options.IConfigValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final ClientConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public final ForgeConfigSpec.IntValue ROWS;
    public final ForgeConfigSpec.IntValue COLUMNS;
    public final ForgeConfigSpec.BooleanValue AUTO_SUIT_COLUMN;
    public final ForgeConfigSpec.EnumValue<TextureMode> TEXTURE;
    public final Map<String, ForgeConfigSpec.BooleanValue> PAGE2HIDING = new LinkedHashMap<String, ForgeConfigSpec.BooleanValue>();
    public final ForgeConfigSpec.BooleanValue ATTACHING;
    public final ForgeConfigSpec.BooleanValue ENABLE_DEBUG;
    public final ForgeConfigSpec.IntValue MAX_PAGE_BARS;
    public final IClientConfig INSTANCE = new IClientConfig(){

        private static IConfigValue<Boolean> convert(ForgeConfigSpec.BooleanValue value) {
            return IConfigValue.of(value, arg_0 -> ((ForgeConfigSpec.BooleanValue)value).set(arg_0));
        }

        private static IConfigValue<Integer> convert(ForgeConfigSpec.IntValue value) {
            return IConfigValue.of(value, arg_0 -> ((ForgeConfigSpec.IntValue)value).set(arg_0));
        }

        @Override
        public IConfigValue<Boolean> attaching() {
            return 1.convert(ClientConfig.this.ATTACHING);
        }

        @Override
        public IConfigValue<Integer> rows() {
            return 1.convert(ClientConfig.this.ROWS);
        }

        @Override
        public IConfigValue<Integer> columns() {
            return 1.convert(ClientConfig.this.COLUMNS);
        }

        @Override
        public IConfigValue<Boolean> autoSuitColumn() {
            return 1.convert(ClientConfig.this.AUTO_SUIT_COLUMN);
        }

        @Override
        public IConfigValue<TextureMode> textureMode() {
            return IConfigValue.of(ClientConfig.this.TEXTURE, arg_0 -> ClientConfig.this.TEXTURE.set(arg_0));
        }

        @Override
        public IConfigValue<Boolean> screenDebugging() {
            return 1.convert(ClientConfig.this.ENABLE_DEBUG);
        }

        @Override
        public IConfigValue<Integer> maxPageBarCount() {
            return 1.convert(ClientConfig.this.MAX_PAGE_BARS);
        }

        @Override
        public Set<String> hidingPageIds() {
            return ClientConfig.this.PAGE2HIDING.entrySet().stream().filter(entry -> (Boolean)((ForgeConfigSpec.BooleanValue)entry.getValue()).get()).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        @Override
        public void setPageHiding(String id, boolean hiding) {
            Optional.ofNullable(ClientConfig.this.PAGE2HIDING.get(id)).ifPresent(v -> v.set((Object)hiding));
            CONFIG_SPEC.save();
        }

        @Override
        public void save() {
            CONFIG_SPEC.save();
        }
    };

    private ClientConfig(ForgeConfigSpec.Builder builder) {
        this.ATTACHING = builder.comment("show endless inventory view when opening a menu.").define("attachingMenuScreen", true);
        this.ROWS = builder.comment("Default rows of EndInv view, 0 for auto.").translation("config.endinv.comment.row1").defineInRange("rows", 0, 0, Integer.MAX_VALUE);
        this.COLUMNS = builder.comment("Default columns of EndInv view, 0 for auto.").defineInRange("columns", 9, 0, Integer.MAX_VALUE);
        this.AUTO_SUIT_COLUMN = builder.comment("auto suit in columns if GUI Size is too big.").define("auto_suit_column", true);
        this.TEXTURE = builder.comment("Texture mode of EndInv view, transparent or vanilla menu style").comment("FROM_RESOURCE uses vanilla textures, grid is " + FromResource.CONTAINER_TEXTURE_RESOURCE + ", tab is " + FromResource.TABS_RESOURCE + ".").comment("DEDICATED_LOCATION allows using custom texture in resource packs, to use refer such locations: ").comment("grid: " + FromResource.DEDICATED_CONTAINER_TEXTURE + ", tab: " + FromResource.DEDICATED_TABS + ", item_entry: " + FromResource.ITEM_ENTRY_DISPLAY_RESOURCE).defineEnum("texture_mode", (Enum)TextureMode.FROM_RESOURCE);
        this.ENABLE_DEBUG = builder.comment("Press F3 in screen can show some information of menu screen").define("enable_debug", false);
        this.MAX_PAGE_BARS = builder.defineInRange("max_page_bars", 10, 1, 255);
        for (String id : PageTypeRegistry.getIdList()) {
            ForgeConfigSpec.BooleanValue pageEntry = builder.comment("Hide page: " + id).define("hide_pages." + id, false);
            this.PAGE2HIDING.put(id, pageEntry);
        }
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CONFIG = (ClientConfig)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

