/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.forge.mixin;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.util.recipeTransferHelper.RecipeItemProvider;
import javax.annotation.Nullable;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlaceRecipe.class})
public class ServerPlaceRecipeMixin<C extends Container> {
    @Final
    @Shadow
    protected StackedContents f_135426_;
    @Unique
    @Nullable
    private EndlessInventory endInv;
    @Unique
    private int ei$lastIndex = Integer.MIN_VALUE;

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/RecipeBookMenu;fillCraftSlotsStackedContents(Lnet/minecraft/world/entity/player/StackedContents;)V")})
    private void fillEndInvStackedContents(ServerPlayer player, Recipe<C> recipe, boolean placeAll, CallbackInfo ci) {
        this.endInv = ServerLevelEndInv.getEndInvForPlayer((Player)player).orElse(null);
        if (this.endInv == null) {
            return;
        }
        RecipeItemProvider.fillStackedContents(this.endInv.getItemsAsList(), this.f_135426_);
    }

    @Inject(method={"recipeClicked"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/recipebook/ServerPlaceRecipe;handleRecipeClicked(Lnet/minecraft/world/item/crafting/Recipe;Z)V")})
    private void finishHandleClick(ServerPlayer player, Recipe<C> recipe, boolean placeAll, CallbackInfo ci) {
        if (this.endInv != null) {
            this.endInv.broadcastChanges();
        }
    }

    @ModifyVariable(method={"moveItemToGrid"}, at=@At(value="STORE"), ordinal=0)
    private int ei$captureIndex(int i) {
        this.ei$lastIndex = i;
        return i;
    }

    @Inject(method={"moveItemToGrid"}, at={@At(value="RETURN")})
    private void ei$afterMove(Slot slotToFill, ItemStack ingredient, CallbackInfo ci) {
        if (this.ei$lastIndex != -1) {
            return;
        }
        if (this.endInv == null) {
            return;
        }
        ItemStack taken = this.endInv.takeItem(ingredient, 1);
        if (taken.m_41619_()) {
            return;
        }
        ItemStack cur = slotToFill.m_7993_();
        if (cur.m_41619_()) {
            slotToFill.m_5852_(taken.m_41777_());
        } else {
            cur.m_41769_(taken.m_41613_());
        }
    }
}

