/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common;

import com.kwwsyk.endinv.common.EndInvAffinities;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemStackLike;
import com.kwwsyk.endinv.common.util.ItemState;
import com.kwwsyk.endinv.common.util.SortType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;

public class EndlessInventory
extends SourceInventory {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<class_1799>[] sortedViews = new List[SortType.values().length];
    private final long[] lastSortedTimes = new long[SortType.values().length];
    public final EndInvAffinities affinities;
    public List<class_3222> viewers = new ArrayList<class_3222>();

    public EndlessInventory() {
        this(UUID.randomUUID());
    }

    public EndlessInventory(UUID uuid) {
        super(uuid);
        this.affinities = new EndInvAffinities(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<class_1799> getSortedView(SortType type, boolean reverse) {
        int idx = type.ordinal();
        List<class_1799>[] listArray = this.sortedViews;
        synchronized (this.sortedViews) {
            if (this.lastSortedTimes[idx] != this.lastModTime || this.sortedViews[idx] == null) {
                List<class_1799> view = this.snapshotItems();
                view.sort(ModInfo.sortHelper.getComparator(type, this));
                this.sortedViews[idx] = view;
                this.lastSortedTimes[idx] = this.lastModTime;
            }
            ArrayList<class_1799> result = new ArrayList<class_1799>(this.sortedViews[idx]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (reverse) {
                Collections.reverse(result);
            }
            return result;
        }
    }

    public List<ItemStackLike> getStarredItems(@Nonnegative int startIndex, @Nonnegative int length) {
        List<class_1799> items = this.affinities.getStarredItems(startIndex, length);
        return items.stream().map(this::getStackWithZeroCount).toList();
    }

    public List<ItemStackLike> getStarredItems() {
        return this.getStarredItems(0, this.affinities.starredItems.size());
    }

    public ItemStackLike getStackWithZeroCount(class_1799 stack) {
        ItemState state = (ItemState)this.itemMap.get(ItemKey.asKey(stack));
        if (state == null) {
            return ItemStackLike.asKey(stack);
        }
        return ItemStackLike.asKey(stack, state.count());
    }

    @Nullable
    public Optional<class_3222> getOwner(class_3218 level) {
        return level.method_18766(pl -> Objects.equals(pl.method_5667(), this.owner)).stream().findAny();
    }

    @Override
    public void setChanged() {
        super.setChanged();
        ServerLevelEndInv.levelEndInvData.method_80();
    }

    public long updateModState(long newState) {
        if (newState <= this.lastModTime) {
            newState = this.lastModTime + 1L;
        }
        this.lastModTime = newState;
        return this.lastModTime;
    }

    public void broadcastChanges() {
    }
}

