/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.autopick;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.autopick.events.IBlockBreakEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.ILivingExpDropsEvent;
import com.kwwsyk.endinv.common.autopick.events.IPlayerPickupItemEvent;
import com.kwwsyk.endinv.common.network.payloads.toClient.ItemPickedUpPayload;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1749;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1819;
import net.minecraft.class_1820;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class AutoPickHelper {
    public static boolean isEnabled(class_1657 player) {
        return AutoPickHelper.isPlayerEnabledAutoPick(player) && ModInfo.getServerConfig().enableAutoPick().get() != false;
    }

    private static boolean isPlayerEnabledAutoPick(class_1657 player) {
        return ModRegistries.NbtAttachments.getSyncedConfig().getWith(player).autoPicking();
    }

    public static void onLivingDrops(ILivingDropsEvent event) {
        class_1297 class_12972 = event.getSource().method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_12972;
        if (AutoPickHelper.isEnabled((class_1657)player)) {
            EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((class_1657)player).orElse(null);
            if (endInv == null) {
                return;
            }
            boolean flag = true;
            for (class_1542 drop : event.getDrops()) {
                class_1799 stack = drop.method_6983();
                class_1799 remain = endInv.addItem(stack);
                stack.method_7971(remain.method_7947());
                if (!stack.method_7960()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack));
                }
                if (remain.method_7960()) {
                    drop.method_5650(class_1297.class_5529.field_26999);
                    continue;
                }
                drop.method_6979(remain);
                flag = false;
            }
            if (flag) {
                event.setCanceled(true);
            }
        }
    }

    public static void onExpDrops(ILivingExpDropsEvent event) {
        class_1657 class_16572 = event.getAttackingPlayer();
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            if (!AutoPickHelper.isEnabled((class_1657)player)) {
                return;
            }
            int exp = event.getDroppedExperience();
            int newValue = AutoPickHelper.repairPlayerItems((class_1657)player, exp);
            player.method_7255(newValue);
            event.setCanceled(true);
        }
    }

    public static void onBlockBreak(IBlockBreakEvent event) {
        class_1657 class_16572 = event.getPlayer();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        if (!AutoPickHelper.isEnabled((class_1657)player)) {
            return;
        }
        EndlessInventory endInv = ServerLevelEndInv.getEndInvForPlayer((class_1657)player).orElse(null);
        if (endInv == null) {
            return;
        }
        class_3218 level = (class_3218)event.getLevel();
        class_2338 pos = event.getPos();
        class_2680 state = level.method_8320(pos);
        class_2586 blockEntity = level.method_8321(pos);
        List drops = class_2248.method_9609((class_2680)state, (class_3218)level, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_6047());
        if (event.getExpToDrop() > 0) {
            int exp = event.getExpToDrop();
            int repaired = AutoPickHelper.repairPlayerItems((class_1657)player, exp);
            player.method_7255(repaired);
            event.setExpToDrop(0);
        }
        boolean allPicked = true;
        for (class_1799 drop : drops) {
            class_1799 remain = endInv.addItem(drop.method_7972());
            drop.method_7934(remain.method_7947());
            if (!drop.method_7960()) {
                ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(drop));
            }
            if (remain.method_7960()) continue;
            allPicked = false;
            level.method_8649((class_1297)new class_1542((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, remain));
        }
        if (allPicked) {
            event.setCanceled(true);
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    public static void onPickupItem(IPlayerPickupItemEvent event) {
        class_3222 player;
        class_1657 class_16572 = event.getPlayer();
        if (!(class_16572 instanceof class_3222) || AutoPickHelper.isEnabled((class_1657)(player = (class_3222)class_16572))) {
            return;
        }
        class_1542 entity = event.getItem();
        if (entity.method_6977()) {
            return;
        }
        class_1799 stack = entity.method_6983();
        if (AutoPickHelper.shouldMoveTo((class_1657)player, stack)) {
            ServerLevelEndInv.getEndInvForPlayer((class_1657)player).ifPresent(endInv -> {
                class_1799 remain = endInv.addItem(stack.method_7972());
                if (!stack.method_7960()) {
                    ModInfo.getPacketDistributor().sendToPlayer(player, new ItemPickedUpPayload(stack.method_7972()));
                }
                if (remain.method_7960()) {
                    stack.method_7939(0);
                } else {
                    stack.method_7971(remain.method_7947());
                }
            });
        }
    }

    private static boolean shouldMoveTo(class_1657 player, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1829) {
            class_1829 swordItem = (class_1829)item;
            return AutoPickHelper.hasSuch(player, (class_1792)swordItem);
        }
        if (item instanceof class_1743) {
            class_1743 axeItem = (class_1743)item;
            return AutoPickHelper.hasSuch(player, (class_1792)axeItem);
        }
        if (item instanceof class_1810) {
            class_1810 such = (class_1810)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1821) {
            class_1821 such = (class_1821)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1794) {
            class_1794 such = (class_1794)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1835) {
            class_1835 such = (class_1835)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1819) {
            class_1819 such = (class_1819)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1820) {
            class_1820 such = (class_1820)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1749) {
            class_1749 such = (class_1749)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1770) {
            class_1770 such = (class_1770)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1753) {
            class_1753 such = (class_1753)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1764) {
            class_1764 such = (class_1764)item;
            return AutoPickHelper.hasSuch(player, (class_1792)such);
        }
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return AutoPickHelper.hasOrSwearing(player, armorItem);
        }
        return !AutoPickHelper.canMerge(player, stack);
    }

    private static boolean canMerge(class_1657 player, class_1799 stack) {
        return player.field_7498.field_7761.stream().anyMatch(slot -> class_1799.method_31577((class_1799)slot.method_7677(), (class_1799)stack));
    }

    private static boolean hasSuch(class_1657 player, class_1792 item) {
        return player.field_7498.field_7761.stream().anyMatch(slot -> slot.method_7677().method_7909().getClass() == item.getClass());
    }

    private static boolean hasOrSwearing(class_1657 player, class_1738 armor) {
        class_1304 slot = armor.method_7685();
        class_1799 equipped = player.method_6118(slot);
        if (equipped.method_7960()) {
            return player.field_7498.field_7761.stream().anyMatch(slt -> {
                class_1738 a1;
                class_1792 patt9028$temp = slt.method_7677().method_7909();
                return patt9028$temp instanceof class_1738 && (a1 = (class_1738)patt9028$temp).method_7685() == slot;
            });
        }
        return true;
    }

    private static int repairPlayerItems(class_1657 player, int repairAmount) {
        Map.Entry entry = class_1890.method_24365((class_1887)class_1893.field_9101, (class_1309)player, class_1799::method_7986);
        if (entry != null) {
            class_1799 itemstack = (class_1799)entry.getValue();
            int i = Math.min((int)((float)repairAmount * itemstack.getXpRepairRatio()), itemstack.method_7919());
            itemstack.method_7974(itemstack.method_7919() - i);
            int j = repairAmount - i / 2;
            return j > 0 ? AutoPickHelper.repairPlayerItems(player, j) : 0;
        }
        return repairAmount;
    }
}

