/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.SourceInventory;
import com.kwwsyk.endinv.common.network.payloads.toClient.EndInvMetadata;
import com.kwwsyk.endinv.common.options.ContentTransferMode;
import com.kwwsyk.endinv.common.util.ItemKey;
import com.kwwsyk.endinv.common.util.ItemState;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_1799;

public class CachedSrcInv
extends SourceInventory {
    public static final CachedSrcInv INSTANCE = new CachedSrcInv();
    private int itemSize;
    private boolean validSize;

    private CachedSrcInv() {
        super(ModInfo.DEFAULT_UUID);
    }

    public void initializeContents(Map<ItemKey, ItemState> itemMap) {
        this.overwriteItems((Map<ItemKey, ItemState>)new Object2ObjectLinkedOpenHashMap(itemMap));
        this.itemSize = this.getItemSize();
        this.validSize = true;
    }

    @Override
    public int getItemSize() {
        if (ModInfo.getServerConfig().transferMode().get() == ContentTransferMode.PART) {
            return this.itemSize;
        }
        if (this.validSize) {
            return this.itemSize;
        }
        return super.getItemSize();
    }

    @Override
    public class_1799 takeItem(class_1799 stack, int count) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        ItemKey key = ItemKey.asKey(stack);
        ItemState state = (ItemState)this.itemMap.get(key);
        if (state == null) {
            return class_1799.field_8037;
        }
        if (state.count() >= this.maxStackSize && this.infinityMode) {
            this.setChanged();
            return stack.method_46651(count);
        }
        int taken = Math.min(count, state.count());
        class_1799 result = stack.method_46651(taken);
        if (taken == state.count()) {
            this.itemMap.remove(key);
            this.updateLastModTime();
        } else {
            this.itemMap.put(key, new ItemState(state.count() - taken, this.updateLastModTime()));
        }
        this.setChanged();
        return result;
    }

    @Override
    public class_1799 addItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        ItemKey key = ItemKey.asKey(itemStack);
        ItemState state = (ItemState)this.itemMap.get(key);
        int count = itemStack.method_7947();
        int original = 0;
        if (state != null) {
            original = state.count();
        }
        if (original < this.maxStackSize) {
            int increased = original + count;
            if (increased <= this.maxStackSize) {
                this.itemMap.put(key, new ItemState(increased, this.updateLastModTime()));
                this.setChanged();
                return class_1799.field_8037;
            }
            this.itemMap.put(key, new ItemState(this.maxStackSize, this.updateLastModTime()));
            this.setChanged();
            return itemStack.method_46651(increased - this.maxStackSize);
        }
        if (this.infinityMode) {
            this.itemMap.put(key, new ItemState(original, this.updateLastModTime()));
            this.setChanged();
            return class_1799.field_8037;
        }
        return itemStack.method_7972();
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.validSize = false;
    }

    @Override
    public long updateLastModTime() {
        return class_156.method_658();
    }

    public void syncMetadata(EndInvMetadata endInvMetadata) {
        this.itemSize = endInvMetadata.itemSize();
        this.maxStackSize = endInvMetadata.maxStackSize();
        this.infinityMode = endInvMetadata.infinityMode();
        this.accessibility = endInvMetadata.config().accessibility();
        this.owner = endInvMetadata.config().owner();
        this.white_list = endInvMetadata.config().white_list();
    }
}

