/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.client.gui;

import com.kwwsyk.endinv.common.client.CachedSrcInv;
import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.options.IConfigValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EndInvSettingScreen
extends class_437 {
    private static final int CONFIG_ENTRY_Y_OFFSET = 17;
    private static final int CONFIG_ENTRY_X_OFFSET = 10;
    private static final int ENTRY_HEIGHT = 20;
    private static final int MAX_ENTRY_COUNT = 7;
    private static final int WIDGET_X_OFFSET = 165;
    private static final int WIDGET_X_SIZE = 60;
    private static final int WIDGET_Y_SIZE = 18;
    private final class_437 back;
    private int leftPos;
    private int topPos;
    private final int imageWidth = 248;
    private final int imageHeight = 166;
    private int pageIndex = 0;
    private int entryOffset = 0;
    private double scrollOffset = 0.0;
    public final List<EntryBuilder> entries = new ArrayList<EntryBuilder>();
    public final EntryBuilder[] renderingEntries = new EntryBuilder[7];
    @Nullable
    private class_342 typingEditBox;

    public EndInvSettingScreen(class_437 lastScreen) {
        super((class_2561)class_2561.method_43471((String)"title.endinv.settings"));
        this.back = lastScreen;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.switchPage();
    }

    private void switchPage() {
        this.entries.clear();
        Arrays.fill(this.renderingEntries, null);
        this.method_37067();
        this.addPageSwitchButton();
        if (this.pageIndex == 1) {
            this.addInfoEntry((class_2561)class_2561.method_43471((String)"endinv.info.accessibility"), CachedSrcInv.INSTANCE::getAccessibility);
            this.addInfoEntry((class_2561)class_2561.method_43471((String)"endinv.info.owner_uuid"), CachedSrcInv.INSTANCE::getOwnerUUID);
            this.addInfoEntry((class_2561)class_2561.method_43471((String)"endinv.info.white_list_size"), () -> "Size :" + CachedSrcInv.INSTANCE.white_list.size());
        } else {
            this.addConfigEntry("endinv.setting.rows", ClientModInfo.getClientConfig().rows());
            this.addConfigEntry("endinv.setting.columns", ClientModInfo.getClientConfig().columns());
            this.addConfigEntry("endinv.setting.auto_suit", ClientModInfo.getClientConfig().autoSuitColumn());
            this.addConfigEntry("endinv.setting.attaching", ClientModInfo.getClientConfig().attaching());
            this.addConfigEntry("endinv.setting.texture", ClientModInfo.getClientConfig().textureMode());
            this.addConfigEntry("endinv.setting.max_page_bar", ClientModInfo.getClientConfig().maxPageBarCount());
            this.addConfigEntry((class_2561)class_2561.method_43470((String)"Screen debug"), ClientModInfo.getClientConfig().screenDebugging());
        }
        this.scrollTo();
    }

    private void scrollTo() {
        for (int i = 0; i < Math.min(7, this.entries.size()); ++i) {
            assert (this.entryOffset < this.entries.size() - i);
            this.renderingEntries[i] = this.entries.get(i + this.entryOffset);
        }
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.build();
            entry.syncConfig();
        }
    }

    private void pageSwitched(int index) {
        this.pageIndex = index;
        this.switchPage();
    }

    private <T> void addConfigEntry(String key, IConfigValue<T> configValue) {
        this.addConfigEntry((class_2561)class_2561.method_43471((String)key), configValue);
    }

    private <T> void addConfigEntry(class_2561 tip, IConfigValue<T> configValue) {
        this.entries.add(new ConfigEntry<T>(this.entries.size(), tip, configValue.get(), configValue));
    }

    private void addInfoEntry(class_2561 tip, Supplier<Object> info) {
        this.entries.add(new InfoEntry(this.entries.size(), tip, info));
    }

    private void addPageSwitchButton() {
        class_4185 left = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), btn -> this.pageSwitched(class_3532.method_15340((int)(this.pageIndex - 1), (int)0, (int)1))).method_46433(this.leftPos - 20, this.topPos).method_46437(20, 20).method_46431();
        class_4185 right = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), btn -> this.pageSwitched(class_3532.method_15340((int)(this.pageIndex + 1), (int)0, (int)1))).method_46433(this.leftPos + 248 + 1, this.topPos).method_46437(20, 20).method_46431();
        this.method_37063((class_364)left);
        this.method_37063((class_364)right);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_25420(guiGraphics);
        for (EntryBuilder entry : this.renderingEntries) {
            if (entry == null) continue;
            entry.render(guiGraphics, partialTick, mouseX, mouseY);
        }
    }

    public void method_25420(@NotNull class_332 guiGraphics) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, -100.0f);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 248, this.topPos + 166, -2004318072);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.back);
        ClientModInfo.getClientConfig().save();
    }

    public boolean method_25400(char code, int modifiers) {
        if (super.method_25400(code, modifiers)) {
            class_342 editBox;
            class_364 class_3642 = this.method_25399();
            this.typingEditBox = class_3642 instanceof class_342 ? (editBox = (class_342)class_3642) : null;
        }
        return false;
    }

    public void method_25393() {
        boolean flag;
        super.method_25393();
        boolean bl = flag = this.method_25399() == null || !this.method_25399().method_25370() || this.method_25399() != this.typingEditBox;
        if (flag && this.typingEditBox != null) {
            for (EntryBuilder entry : this.entries) {
                entry.getEditBox().ifPresent(editBox -> {
                    if (editBox == this.typingEditBox) {
                        entry.applyChanges();
                        this.typingEditBox = null;
                    }
                });
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 && this.method_25399() != null) {
            this.method_25399().method_25365(false);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25399() != null || button == 1) {
            this.method_25399().method_25365(false);
            this.method_25395(null);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (this.entries.size() > 7) {
            if (this.scrollOffset < 1.0 && scrollY < 0.0) {
                this.scrollOffset = class_3532.method_15350((double)(this.scrollOffset + scrollY), (double)0.0, (double)1.0);
            }
            if (this.scrollOffset > 0.0 && scrollY > 0.0) {
                this.scrollOffset = class_3532.method_15350((double)(this.scrollOffset - scrollY), (double)0.0, (double)1.0);
            }
            this.entryOffset = (int)Math.floor(this.scrollOffset * (double)(this.entries.size() - 7));
            this.scrollTo();
        }
        return super.method_25401(mouseX, mouseY, scrollY);
    }

    public static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.method_27525((class_5348)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)class_156.method_658() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = class_3532.method_16436((double)d2, (double)0.0, (double)l);
            guiGraphics.method_44379(minX, minY, maxX, maxY);
            guiGraphics.method_27535(font, text, minX - (int)d3, j, color);
            guiGraphics.method_44380();
        } else {
            guiGraphics.method_27534(font, text, (minX + maxX) / 2, j, color);
        }
    }

    public static interface EntryBuilder {
        public void build();

        public void render(class_332 var1, float var2, int var3, int var4);

        public void syncConfig();

        public void applyChanges();

        default public Optional<class_342> getEditBox() {
            return Optional.empty();
        }
    }

    public class ConfigEntry<T>
    implements EntryBuilder {
        public final int index;
        private final class_2561 tip;
        private final IConfigValue<T> configValue;
        private final T initialValue;
        private class_339 configWidget;
        int widgetX;
        int widgetY;

        public ConfigEntry(int index, class_2561 tip, T initialValue, IConfigValue<T> configValue) {
            this.index = index;
            this.tip = tip;
            this.configValue = configValue;
            this.initialValue = initialValue;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            if (this.initialValue instanceof Boolean) {
                IConfigValue booleanValue = this.configValue;
                class_5676 button = class_5676.method_32613((boolean)((Boolean)this.initialValue)).method_32616().method_32617(this.widgetX, this.widgetY, 60, 18, (class_2561)class_2561.method_43473(), (btn, value) -> booleanValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.method_37063((class_364)button);
            } else if (this.initialValue instanceof Enum) {
                IConfigValue enumValue = this.configValue;
                class_5676 button = new class_5676.class_5677(e -> class_2561.method_43471((String)("endinv.setting.entry." + e.name()))).method_32624((Object[])((Enum[])this.initialValue.getClass().getEnumConstants())).method_32619((Object)((Enum)this.initialValue)).method_32616().method_32617(this.widgetX, this.widgetY, 60, 18, (class_2561)class_2561.method_43473(), (btn, value) -> enumValue.set(value));
                this.configWidget = button;
                EndInvSettingScreen.this.method_37063((class_364)button);
            } else if (this.initialValue instanceof Integer) {
                class_342 editBox = new class_342(EndInvSettingScreen.this.field_22793, this.widgetX, this.widgetY, 60, 18, this.tip);
                this.configWidget = editBox;
                EndInvSettingScreen.this.method_37063((class_364)editBox);
            } else {
                EndInvSettingScreen self = EndInvSettingScreen.this;
                self.method_37060((guiGraphics, i, i1, v) -> guiGraphics.method_25303(self.field_22793, "Error", this.widgetX, this.widgetY, -51401));
            }
        }

        @Override
        public void render(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.method_27535(EndInvSettingScreen.this.field_22793, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            class_339 class_3392 = this.configWidget;
            if (class_3392 instanceof class_5676) {
                class_5676 button = (class_5676)class_3392;
                button.method_32605(this.configValue.get());
            } else {
                class_3392 = this.configWidget;
                if (class_3392 instanceof class_342) {
                    class_342 editBox = (class_342)class_3392;
                    editBox.method_1852(String.valueOf(this.configValue.get()));
                }
            }
        }

        @Override
        public void applyChanges() {
            class_339 class_3392 = this.configWidget;
            if (class_3392 instanceof class_342) {
                class_342 editBox = (class_342)class_3392;
                T parsed = this.parse(editBox.method_1882());
                if (parsed == null) {
                    return;
                }
                this.configValue.set(parsed);
            }
        }

        @Override
        public Optional<class_342> getEditBox() {
            Optional<class_342> optional;
            class_339 class_3392 = this.configWidget;
            if (class_3392 instanceof class_342) {
                class_342 box = (class_342)class_3392;
                optional = Optional.of(box);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        private T parse(String s) {
            try {
                return (T)Integer.valueOf(s);
            }
            catch (Exception e) {
                ((class_342)this.configWidget).method_1852(String.valueOf(this.configValue.get()));
                return null;
            }
        }

        public class_2561 getTip() {
            return this.tip;
        }

        public IConfigValue<?> getConfigValue() {
            return this.configValue;
        }
    }

    public class InfoEntry
    implements EntryBuilder {
        private final class_2561 tip;
        private final Supplier<Object> info;
        int widgetMidX;
        int widgetY;

        public InfoEntry(int index, class_2561 tip, Supplier<Object> info) {
            this.tip = tip;
            this.info = info;
            this.widgetMidX = EndInvSettingScreen.this.leftPos + 165 + 30 - 40;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
        }

        @Override
        public void render(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
            class_327 font = EndInvSettingScreen.this.field_22793;
            guiGraphics.method_27535(font, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
            class_5250 v = class_2561.method_43470((String)(this.info.get() != null ? this.info.get().toString() : "null"));
            int infoLength = Math.min(font.method_30880(v.method_30937()), 100);
            EndInvSettingScreen.renderScrollingString(guiGraphics, font, (class_2561)v, this.widgetMidX - infoLength / 2, this.widgetY, this.widgetMidX + infoLength / 2, this.widgetY + 7, -16711681);
        }

        @Override
        public void syncConfig() {
        }

        @Override
        public void applyChanges() {
        }
    }

    public class EnumAttributeEntry<E extends Enum<?>>
    extends AttributeEntry<Enum<?>> {
        E e;

        public EnumAttributeEntry(int index, class_2561 tip, Supplier<Enum<?>> attributeGetter, Consumer<Enum<?>> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Enum<?> parse(String s) {
            try {
                return Enum.valueOf(this.e.getClass(), s);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public class IntAttributeEntry
    extends AttributeEntry<Integer> {
        public IntAttributeEntry(int index, class_2561 tip, Supplier<Integer> attributeGetter, Consumer<Integer> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        Integer parse(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public class StringAttributeEntry
    extends AttributeEntry<String> {
        public StringAttributeEntry(int index, class_2561 tip, Supplier<String> attributeGetter, Consumer<String> attributeSetter) {
            super(index, tip, attributeGetter, attributeSetter);
        }

        @Override
        String parse(String s) {
            return s;
        }
    }

    public abstract class AttributeEntry<T>
    implements EntryBuilder {
        public final int index;
        private final class_2561 tip;
        private final Supplier<T> attributeGetter;
        private final Consumer<T> attributeSetter;
        private class_342 editBox;
        int widgetX;
        int widgetY;

        public AttributeEntry(int index, class_2561 tip, Supplier<T> attributeGetter, Consumer<T> attributeSetter) {
            this.index = index;
            this.tip = tip;
            this.attributeGetter = attributeGetter;
            this.attributeSetter = attributeSetter;
            this.widgetX = EndInvSettingScreen.this.leftPos + 165;
            this.widgetY = EndInvSettingScreen.this.topPos + 17 + index * 20 + 1;
        }

        @Override
        public void build() {
            class_342 editBox = new class_342(EndInvSettingScreen.this.field_22793, this.widgetX, this.widgetY, 60, 18, (class_2561)class_2561.method_43473());
            EndInvSettingScreen.this.method_37063((class_364)editBox);
            this.editBox = editBox;
        }

        @Override
        public void render(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
            guiGraphics.method_27535(EndInvSettingScreen.this.field_22793, this.tip, EndInvSettingScreen.this.leftPos + 10, this.widgetY, -256);
        }

        @Override
        public void syncConfig() {
            this.editBox.method_1852(this.attributeGetter.get().toString());
        }

        @Override
        public void applyChanges() {
            T t = this.parse(this.editBox.method_1882());
            if (t == null) {
                this.editBox.method_1852(this.attributeGetter.get().toString());
            } else {
                this.attributeSetter.accept(t);
            }
        }

        abstract T parse(String var1);

        @Override
        public Optional<class_342> getEditBox() {
            return Optional.of(this.editBox);
        }
    }
}

