/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.commands;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.data.EndlessInventoryData;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.util.Accessibility;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;

public class EndInvCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"endinv").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"backup").requires(src -> src.method_9259(1))).executes(context -> {
            EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(((class_2168)context.getSource()).method_9225());
            if (result.success()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Backed up at " + result.message())), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Cannot backup as" + result.message())));
            return -1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ofIndex").executes(context -> EndInvCommand.getCurrentIndex((class_2168)context.getSource()))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EndInvCommand.byIndexGet((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))).then(class_2170.method_9247((String)"open").executes(context -> EndInvCommand.byIndexOpen((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setDefault").requires(src -> src.method_9259(1))).executes(context -> EndInvCommand.byIndexSetDefault((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setOwner").requires(src -> src.method_9259(1))).executes(context -> EndInvCommand.byIndexSetOwner((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(class_2170.method_9247((String)"addWhitelist").executes(context -> EndInvCommand.byIndexAddWhitelist((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(class_2170.method_9247((String)"removeWhitelist").executes(context -> EndInvCommand.byIndexRemoveWhitelist((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setAccessibility").then(class_2170.method_9247((String)"public").executes(context -> EndInvCommand.byIndexSetAccessibility((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PUBLIC)))).then(class_2170.method_9247((String)"restricted").executes(context -> EndInvCommand.byIndexSetAccessibility((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.RESTRICTED)))).then(class_2170.method_9247((String)"private").executes(context -> EndInvCommand.byIndexSetAccessibility((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), Accessibility.PRIVATE))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> src.method_9259(1))).then(class_2170.method_9244((String)"forceRemove", (ArgumentType)BoolArgumentType.bool()).executes(context -> EndInvCommand.byIndexRemove((class_2168)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), BoolArgumentType.getBool((CommandContext)context, (String)"forceRemove")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"new").requires(src -> src.method_9259(1))).executes(context -> EndInvCommand.createNew((class_2168)context.getSource(), Accessibility.PUBLIC))).then(class_2170.method_9247((String)"public").executes(context -> EndInvCommand.createNew((class_2168)context.getSource(), Accessibility.PUBLIC)))).then(class_2170.method_9247((String)"restricted").executes(context -> EndInvCommand.createNew((class_2168)context.getSource(), Accessibility.RESTRICTED)))).then(class_2170.method_9247((String)"private").executes(context -> EndInvCommand.createNew((class_2168)context.getSource(), Accessibility.PRIVATE)))));
    }

    private static int byIndexRemove(class_2168 source, int index, boolean forced) {
        EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
        if (endlessInventory == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
            return -1;
        }
        EndlessInventoryData.BackupResult result = EndlessInventoryData.backup(source.method_9225());
        if (!result.success()) {
            if (forced) {
                ServerLevelEndInv.levelEndInvData.byIndexRemove(index);
                source.method_9226(() -> class_2561.method_43470((String)("Force-removed " + endlessInventory.getUuid())), true);
                return index;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)("Cannot backup as " + result.message())));
            return -1;
        }
        source.method_9226(() -> class_2561.method_43470((String)("Backed up at " + result.message())), true);
        source.method_9226(() -> class_2561.method_43470((String)("Removed " + endlessInventory.getUuid())), true);
        return index;
    }

    private static int byIndexAddWhitelist(class_2168 source, int index) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((class_1657)player) && !source.method_9259(1)) {
                source.method_9213((class_2561)class_2561.method_43471((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.white_list.add(player.method_5667());
            source.method_9226(() -> class_2561.method_43470((String)("Add " + player.method_5477().getString() + " to " + endlessInventory.getUuid() + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexRemoveWhitelist(class_2168 source, int index) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.isOwner((class_1657)player) || source.method_9259(1)) {
                if (!endlessInventory.white_list.remove(player.method_5667())) {
                    source.method_9213((class_2561)class_2561.method_43470((String)(player.method_5477().getString() + " is not in " + endlessInventory.getUuid() + "'s whitelist.")));
                    return -1;
                }
            } else {
                source.method_9213((class_2561)class_2561.method_43471((String)"endinv.callback.not_owner"));
                return -1;
            }
            source.method_9226(() -> class_2561.method_43470((String)("Remove " + player.method_5477().getString() + " from " + endlessInventory.getUuid() + "'s whitelist.")), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetAccessibility(class_2168 source, int index, Accessibility accessibility) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (!endlessInventory.isOwner((class_1657)player) && !source.method_9259(1)) {
                source.method_9213((class_2561)class_2561.method_43471((String)"endinv.callback.not_owner"));
                return -1;
            }
            endlessInventory.setAccessibility(accessibility);
            source.method_9226(() -> class_2561.method_43470((String)("Set " + endlessInventory.getUuid() + "'s accessibility to" + accessibility)), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetOwner(class_2168 source, int index) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            endlessInventory.setOwner(player.method_5667());
            source.method_9226(() -> class_2561.method_43470((String)("Set " + endlessInventory.getUuid() + "'s owner to" + player.method_5477().getString())), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int createNew(class_2168 source, Accessibility accessibility) {
        try {
            class_3222 player = source.method_9207();
            switch (accessibility) {
                case PUBLIC: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    source.method_9226(() -> class_2561.method_43470((String)("Created a new public endInv with uuid: " + endInv.getUuid())), true);
                    break;
                }
                case RESTRICTED: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.RESTRICTED);
                    source.method_9226(() -> class_2561.method_43470((String)("Created a new white_list endInv with uuid: " + endInv.getUuid())), true);
                    endInv.white_list.add(player.method_5667());
                    source.method_9226(() -> class_2561.method_43470((String)"Add current player to white list"), true);
                    break;
                }
                case PRIVATE: {
                    EndlessInventory endInv = ServerLevelEndInv.createPublicEndInv();
                    endInv.setAccessibility(Accessibility.PRIVATE);
                    endInv.setOwner(player.method_5667());
                    source.method_9226(() -> class_2561.method_43470((String)("Created a new private endInv with uuid: " + endInv.getUuid() + ", with owner : " + player.method_5477().getString())), true);
                }
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexSetDefault(class_2168 source, int index) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            ModRegistries.NbtAttachments.getEndInvUUID().setTo((class_1657)player, endlessInventory.getUuid());
            source.method_9226(() -> class_2561.method_43470((String)("Set player's default endInv with uuid: " + endlessInventory.getUuid())), true);
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexOpen(class_2168 source, int index) {
        try {
            class_3222 player = source.method_9207();
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            if (endlessInventory.accessible((class_1657)player)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.method_17355((class_3908)new class_747(EndlessInventoryMenu::createWithTemp, (class_2561)class_2561.method_43473()));
            } else if (source.method_9259(1)) {
                ServerLevelEndInv.TEMP_ENDINV_REG.put(player, endlessInventory);
                player.method_17355((class_3908)new class_747(EndlessInventoryMenu::createWithTemp, (class_2561)class_2561.method_43473()));
                source.method_9226(() -> class_2561.method_43470((String)"Opened an unaccessible endInv for op"), true);
            } else {
                source.method_9213((class_2561)class_2561.method_43471((String)"endinv.callback.no_access"));
                return -1;
            }
            return index;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }

    private static int byIndexGet(class_2168 source, int index) {
        try {
            EndlessInventory endlessInventory = ServerLevelEndInv.levelEndInvData.fromIndex(index);
            if (endlessInventory == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)("Cannot get EndInv by index " + index)));
                return -1;
            }
            source.method_9226(() -> class_2561.method_43470((String)("Found endInv with uuid: " + endlessInventory.getUuid())), true);
            return index;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int getCurrentIndex(class_2168 source) {
        try {
            class_3222 serverPlayer = source.method_9207();
            if (!ServerLevelEndInv.hasEndInvUuid((class_1657)serverPlayer)) {
                source.method_9213((class_2561)class_2561.method_43470((String)"This player has not EndInv."));
                return -1;
            }
            Optional<EndlessInventory> optional = ServerLevelEndInv.getEndInvForPlayer((class_1657)serverPlayer);
            if (optional.isPresent()) {
                EndlessInventory endlessInventory = optional.get();
                int index = ServerLevelEndInv.levelEndInvData.getIndex(endlessInventory);
                source.method_9226(() -> class_2561.method_43470((String)("EndInv index: " + index)), true);
                return index;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot get EndInv for player."));
            return -1;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"A player must execute this command."));
            return -1;
        }
    }
}

