/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.network.payloads.toServer;

import com.kwwsyk.endinv.common.EndlessInventory;
import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.ModRegistries;
import com.kwwsyk.endinv.common.ServerLevelEndInv;
import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.menu.page.pageManager.AttachingMonitor;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.mojang.logging.LogUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.slf4j.Logger;

public record OpenEndInvPayload(boolean openNew, int rows, int columns) implements ModPacketPayload
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public OpenEndInvPayload(boolean ofMenu, int rows) {
        this(ofMenu, rows, 9);
    }

    public OpenEndInvPayload() {
        this(false, 6);
    }

    public static void encode(OpenEndInvPayload payload, class_2540 o) {
        o.writeBoolean(payload.openNew);
        o.writeInt(payload.rows);
        o.writeInt(payload.columns);
    }

    public static OpenEndInvPayload decode(class_2540 o) {
        return new OpenEndInvPayload(o.readBoolean(), o.readInt(), o.readInt());
    }

    @Override
    public String id() {
        return "open_endinv";
    }

    @Override
    public void handle(ModPacketContext iPayloadContext) {
        class_3222 player = (class_3222)iPayloadContext.player();
        if (player == null) {
            return;
        }
        if (player.field_7512 == player.field_7498 && this.openNew()) {
            player.method_17355(EndlessInventoryMenu.provide(this.rows));
        } else if (!this.openNew()) {
            if (!this.checkAttachingStatus(player)) {
                LOGGER.warn("Player unable to open AttachingScreen sent open AS.");
                return;
            }
            ServerLevelEndInv.getEndInvForPlayer((class_1657)player).ifPresent(endInv -> {
                AttachingMonitor manager = new AttachingMonitor(player.field_7512, (EndlessInventory)endInv, player);
                ServerLevelEndInv.PAGE_META_DATA_MANAGER.put(player, manager);
                manager.sendEndInvData();
            });
        }
    }

    private boolean checkAttachingStatus(class_3222 player) {
        SyncedConfig syncedConfig = ModRegistries.NbtAttachments.getSyncedConfig().getWith((class_1657)player);
        boolean nbtAttaching = syncedConfig.attaching();
        boolean menuAttachable = ModInfo.getServerConfig().specifiedMenuAttachability().get().attachable((class_1657)player);
        if (!nbtAttaching) {
            LOGGER.warn("Player with attaching=false nbt sent openAttaching payload.");
            ModRegistries.NbtAttachments.getSyncedConfig().setTo((class_1657)player, new SyncedConfig(true, syncedConfig.autoPicking()));
        }
        return menuAttachable;
    }
}

