/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.common.options;

import com.kwwsyk.endinv.common.ModInfo;
import com.kwwsyk.endinv.common.options.IConfigValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_481;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class SpecifiedMenuAttachingConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<class_3917<?>, Boolean>> MAP_CODEC = Codec.unboundedMap((Codec)class_7923.field_41187.method_39673(), (Codec)Codec.BOOL);
    public static final SpecifiedMenuAttachingConfig DEFAULT = new SpecifiedMenuAttachingConfig();
    public static final Codec<SpecifiedMenuAttachingConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("inventory").forGetter(SpecifiedMenuAttachingConfig::isInventoryAttachable), (App)MAP_CODEC.fieldOf("menu_configs").forGetter(SpecifiedMenuAttachingConfig::getConfigs)).apply((Applicative)instance, SpecifiedMenuAttachingConfig::new));
    final Map<class_3917<?>, Boolean> configs = new HashMap();
    private boolean inventoryAttachable;

    public SpecifiedMenuAttachingConfig(boolean inventoryAttachable, Map<class_3917<?>, Boolean> configs) {
        this.configs.putAll(configs);
        this.inventoryAttachable = inventoryAttachable;
    }

    public SpecifiedMenuAttachingConfig() {
        this.inventoryAttachable = true;
    }

    public Map<class_3917<?>, Boolean> getConfigs() {
        return this.configs;
    }

    public boolean isInventoryAttachable() {
        return this.inventoryAttachable;
    }

    public boolean isMenuAttachable(@Nullable class_3917<?> type) {
        if (type == null) {
            return this.isInventoryAttachable();
        }
        Boolean menuConfig = this.getMenuConfig(type);
        return menuConfig != null ? menuConfig : ModInfo.getServerConfig().enableAttaching().get();
    }

    public boolean isMenuAttachable(class_1703 menu) {
        if (menu instanceof class_1723 || menu instanceof class_481.class_483) {
            return this.isInventoryAttachable();
        }
        return this.isMenuAttachable(menu.method_17358());
    }

    public boolean attachable(class_1657 player) {
        return this.isMenuAttachable(player.field_7512);
    }

    @Nullable
    public Boolean getMenuConfig(@Nullable class_3917<?> type) {
        if (type == null) {
            return this.isInventoryAttachable();
        }
        return this.configs.get(type);
    }

    public void putConfig(@Nullable class_3917<?> menu, boolean attachable) {
        if (menu == null) {
            this.setInventoryAttachable(attachable);
        }
        this.configs.put(menu, attachable);
    }

    public void setInventoryAttachable(boolean attachable) {
        this.inventoryAttachable = attachable;
    }

    public void clearConfigs() {
        this.configs.clear();
    }

    public void fill(boolean defaultValue, boolean overrideOriginal) {
        if (overrideOriginal) {
            this.configs.replaceAll((k, v) -> defaultValue);
        }
        for (class_3917 type : class_7923.field_41187) {
            this.configs.putIfAbsent(type, defaultValue);
        }
        if (overrideOriginal) {
            this.setInventoryAttachable(defaultValue);
        }
    }

    public void trimNonsenseValues() {
        Boolean target = ModInfo.getServerConfig().enableAttaching().get();
        this.configs.entrySet().removeIf(e -> Objects.equals(e.getValue(), target));
    }

    public void invertAllPresent() {
        this.configs.replaceAll((k, v) -> v == null ? null : Boolean.valueOf(v == false));
    }

    public static class Parser {
        public static final String[] configComments = new String[]{"The list holds menu attachability configs", "The format is \"namespace:id:\"", "Such as \"endless_inventory:endinv_menu:false\" (Meanwhile endinv_menu will never be attached)", "Use \"inventory:true(false)\" for inventory menu."};
        private final SpecifiedMenuAttachingConfig config;

        public Parser() {
            this.config = new SpecifiedMenuAttachingConfig();
        }

        public Parser(SpecifiedMenuAttachingConfig config) {
            this.config = config;
        }

        public static SpecifiedMenuAttachingConfig readList(List<String> list) {
            Parser parser = new Parser();
            for (String s : list) {
                parser.parseString(s);
            }
            return parser.config;
        }

        public List<String> encodeConfig() {
            return Parser.fromMap(this.config.configs);
        }

        public static List<String> fromMap(Map<class_3917<?>, Boolean> map) {
            ArrayList<String> out = new ArrayList<String>(map.size());
            for (Map.Entry<class_3917<?>, Boolean> e : map.entrySet()) {
                class_2960 id = class_7923.field_41187.method_10221(e.getKey());
                if (id == null || e.getValue() == null) continue;
                out.add(id + ":" + e.getValue());
            }
            out.sort(Comparator.naturalOrder());
            return out;
        }

        public boolean parseString(String configEntry) {
            ParseStringResult entry = Parser.tryParseString(configEntry);
            if (!entry.success) {
                LOGGER.warn("Menu attachability config parser failed to parse string entry {}.", (Object)configEntry);
                return false;
            }
            this.config.putConfig(entry.type, entry.value);
            return true;
        }

        public static ParseStringResult tryParseString(String configEntry) {
            try {
                int LCIndex = Parser.lastColon(configEntry);
                String boolTxt = configEntry.substring(LCIndex + 1).trim();
                String namespaceTxt = configEntry.substring(0, LCIndex).trim();
                boolean value = Parser.parseBoolean(boolTxt);
                class_2960 rl = class_2960.parse((String)namespaceTxt);
                if (rl.method_12832().equals("inventory") || rl.method_12832().equals("inventory_menu")) {
                    return new ParseStringResult(true, null, value);
                }
                class_3917 type = (class_3917)class_7923.field_41187.method_10223(rl);
                if (type == null) {
                    return ParseStringResult.FAILED;
                }
                return new ParseStringResult(true, type, value);
            }
            catch (Exception e) {
                return ParseStringResult.FAILED;
            }
        }

        private static int lastColon(String s) {
            return s != null ? s.lastIndexOf(58) : -1;
        }

        private static boolean parseBoolean(String s) {
            if (s.equals("1")) {
                return true;
            }
            return Boolean.parseBoolean(s);
        }

        public SpecifiedMenuAttachingConfig getConfig() {
            return this.config;
        }

        public static void testConfig() {
            IConfigValue<SpecifiedMenuAttachingConfig> a = ModInfo.getServerConfig().specifiedMenuAttachability();
            SpecifiedMenuAttachingConfig b = a.get();
            b.fill(true, false);
            a.set(b);
        }

        public record ParseStringResult(boolean success, @Nullable class_3917<?> type, boolean value) {
            public static final ParseStringResult FAILED = new ParseStringResult(false, null, false);
        }
    }
}

