/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.integrates.clothconfig;

import com.kwwsyk.endinv.common.client.ClientModInfo;
import com.kwwsyk.endinv.common.client.option.IClientConfig;
import com.kwwsyk.endinv.common.client.option.TextureMode;
import com.kwwsyk.endinv.common.menu.page.PageTypeRegistry;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

final class ClothConfigScreenBuilder {
    private static final boolean DEFAULT_ATTACHING = true;
    private static final int DEFAULT_ROWS = 0;
    private static final int DEFAULT_COLUMNS = 9;
    private static final boolean DEFAULT_AUTO_SUIT = true;
    private static final TextureMode DEFAULT_TEXTURE = TextureMode.FROM_RESOURCE;
    private static final boolean DEFAULT_SCREEN_DEBUG = false;
    private static final int DEFAULT_MAX_PAGE_BARS = 10;

    private ClothConfigScreenBuilder() {
    }

    static class_437 create(class_437 parent) {
        IClientConfig config = ClientModInfo.getClientConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"title.endinv.settings"));
        builder.setSavingRunnable(config::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"endinv.setting.category.general"));
        ClothConfigScreenBuilder.addGeneralEntries(entryBuilder, general, config);
        ClothConfigScreenBuilder.addPageEntries(entryBuilder, builder, config);
        return builder.build();
    }

    private static void addGeneralEntries(ConfigEntryBuilder entryBuilder, ConfigCategory category, IClientConfig config) {
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"endinv.setting.attaching"), config.attaching().get().booleanValue()).setDefaultValue(true).setSaveConsumer(value -> config.attaching().set((Boolean)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"endinv.setting.rows"), config.rows().get().intValue()).setDefaultValue(0).setMin(0).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.endinv.comment.row1")}).setSaveConsumer(value -> config.rows().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"endinv.setting.columns"), config.columns().get().intValue()).setDefaultValue(9).setMin(0).setSaveConsumer(value -> config.columns().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"endinv.setting.auto_suit"), config.autoSuitColumn().get().booleanValue()).setDefaultValue(true).setSaveConsumer(value -> config.autoSuitColumn().set((Boolean)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"endinv.setting.texture"), TextureMode.class, (Enum)config.textureMode().get()).setDefaultValue((Enum)DEFAULT_TEXTURE).setEnumNameProvider(mode -> class_2561.method_43471((String)("endinv.setting.entry." + mode.name()))).setSaveConsumer(value -> config.textureMode().set((TextureMode)((Object)value))).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)class_2561.method_43471((String)"endinv.setting.max_page_bar"), config.maxPageBarCount().get().intValue()).setDefaultValue(10).setMin(1).setSaveConsumer(value -> config.maxPageBarCount().set((Integer)value)).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"endinv.setting.screen_debug"), config.screenDebugging().get().booleanValue()).setDefaultValue(false).setSaveConsumer(value -> config.screenDebugging().set((Boolean)value)).build());
    }

    private static void addPageEntries(ConfigEntryBuilder entryBuilder, ConfigBuilder builder, IClientConfig config) {
        List<String> pageIds = PageTypeRegistry.getIdList();
        if (pageIds.isEmpty()) {
            return;
        }
        ConfigCategory pages = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"endinv.setting.category.pages"));
        for (String id : pageIds) {
            boolean hidden = config.isPageHidden(id);
            pages.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43469((String)"endinv.setting.hide_page", (Object[])new Object[]{id}), hidden).setDefaultValue(false).setSaveConsumer(value -> config.setPageHiding(id, (boolean)value)).build());
        }
    }
}

