/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.network;

import com.kwwsyk.endinv.common.AbstractModInitializer;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.common.network.payloads.SyncedConfig;
import com.kwwsyk.endinv.common.network.payloads.toServer.CreativeItemModPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemClickPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ItemPageContext;
import com.kwwsyk.endinv.common.network.payloads.toServer.OpenEndInvPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.QuickMoveToPagePayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.StarItemPayload;
import com.kwwsyk.endinv.common.network.payloads.toServer.ToggleCraftingPayload;
import com.kwwsyk.endinv.fabric.network.payloads.JeiTransferRecipePayload;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public final class FabricServerNetworking {
    private FabricServerNetworking() {
    }

    public static void init() {
        FabricServerNetworking.register(ItemClickPayload.class, ItemClickPayload::encode, ItemClickPayload::decode, "item_click");
        FabricServerNetworking.register(CreativeItemModPayload.class, CreativeItemModPayload::encode, CreativeItemModPayload::decode, "item_modify");
        FabricServerNetworking.register(ItemPageContext.class, ItemPageContext::encode, ItemPageContext::decode, "page_context");
        FabricServerNetworking.register(OpenEndInvPayload.class, OpenEndInvPayload::encode, OpenEndInvPayload::decode, "open_endinv");
        FabricServerNetworking.register(QuickMoveToPagePayload.class, QuickMoveToPagePayload::encode, QuickMoveToPagePayload::decode, "quick_move_page");
        FabricServerNetworking.register(StarItemPayload.class, StarItemPayload::encode, StarItemPayload::decode, "star_item");
        FabricServerNetworking.register(ToggleCraftingPayload.class, ToggleCraftingPayload::encode, ToggleCraftingPayload::decode, "toggle_crafting");
        FabricServerNetworking.register(SyncedConfig.class, SyncedConfig::encode, SyncedConfig::decode, SyncedConfig.DEFAULT.id());
        if (FabricLoader.getInstance().isModLoaded("jei")) {
            FabricServerNetworking.register(JeiTransferRecipePayload.class, JeiTransferRecipePayload::encode, JeiTransferRecipePayload::decode, "jei_transfer_recipe");
        }
    }

    private static <T extends ModPacketPayload> void register(Class<T> type, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, String id) {
        class_2960 rid = AbstractModInitializer.withModLocation(id);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)rid, (server, player, handler, buf, response) -> {
            ModPacketPayload payload = (ModPacketPayload)decoder.apply(buf);
            server.execute(() -> payload.handle(FabricServerNetworking.context(player)));
        });
    }

    private static ModPacketContext context(class_3222 player) {
        return () -> player;
    }
}

