/*
 * Decompiled with CFR 0.152.
 */
package com.kwwsyk.endinv.fabric.network.payloads;

import com.kwwsyk.endinv.common.menu.EndlessInventoryMenu;
import com.kwwsyk.endinv.common.network.payloads.ModPacketContext;
import com.kwwsyk.endinv.common.network.payloads.ModPacketPayload;
import com.kwwsyk.endinv.fabric.integrates.jei.EIMRecipeTranHandler;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3955;

public record JeiTransferRecipePayload(int containerId, class_2960 recipeId, boolean maxTransfer) implements ModPacketPayload
{
    public static void encode(JeiTransferRecipePayload payload, class_2540 buffer) {
        buffer.method_10804(payload.containerId);
        buffer.method_10812(payload.recipeId);
        buffer.writeBoolean(payload.maxTransfer);
    }

    public static JeiTransferRecipePayload decode(class_2540 buffer) {
        int containerId = buffer.method_10816();
        class_2960 recipeId = buffer.method_10810();
        boolean maxTransfer = buffer.readBoolean();
        return new JeiTransferRecipePayload(containerId, recipeId, maxTransfer);
    }

    @Override
    public String id() {
        return "jei_transfer_recipe";
    }

    @Override
    public void handle(ModPacketContext context) {
        class_1657 player = context.player();
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!FabricLoader.getInstance().isModLoaded("jei")) {
            return;
        }
        class_1703 class_17032 = serverPlayer.field_7512;
        if (!(class_17032 instanceof EndlessInventoryMenu)) {
            return;
        }
        EndlessInventoryMenu menu = (EndlessInventoryMenu)class_17032;
        if (menu.field_7763 != this.containerId) {
            return;
        }
        Optional optional = serverPlayer.method_51469().method_8433().method_8130(this.recipeId);
        optional.ifPresent(recipeObj -> {
            class_3955 craftingRecipe = JeiTransferRecipePayload.resolveCraftingRecipe(recipeObj);
            if (craftingRecipe != null) {
                EIMRecipeTranHandler.performServerTransfer(menu, craftingRecipe, (class_1657)serverPlayer, this.maxTransfer);
            }
        });
    }

    private static class_3955 resolveCraftingRecipe(Object recipeObj) {
        if (recipeObj instanceof class_3955) {
            class_3955 craftingRecipe = (class_3955)recipeObj;
            return craftingRecipe;
        }
        try {
            Object value = recipeObj.getClass().getMethod("value", new Class[0]).invoke(recipeObj, new Object[0]);
            if (value instanceof class_3955) {
                class_3955 craftingRecipe = (class_3955)value;
                return craftingRecipe;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

