/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.slimeChunkHint;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    @Final
    protected RandomSource random;

    @Inject(method={"vibrationAndSoundEffectsFromBlock"}, at={@At(value="HEAD")})
    private void playStepSoundMixin(BlockPos pos, BlockState state, boolean playStepSound, boolean broadcastGameEvent, Vec3 entityPos, CallbackInfoReturnable<Boolean> cir) {
        if (!ModConfigs.slime_chunk_check) {
            return;
        }
        EntityMixin entityMixin = this;
        if (entityMixin instanceof ServerPlayer) {
            ServerLevel serverLevel;
            ServerPlayer serverPlayer = (ServerPlayer)entityMixin;
            if (!serverPlayer.isShiftKeyDown() && this.random.nextFloat() > 0.1f || serverPlayer.isShiftKeyDown() && this.random.nextFloat() < 0.3f) {
                return;
            }
            boolean holdingSlimeBlock = false;
            Item item = serverPlayer.getItemBySlot(EquipmentSlot.MAINHAND).getItem();
            if (Compare.isHasTag((Item)item, (String)"diversity:slime_detector")) {
                holdingSlimeBlock = true;
            }
            if (Compare.isHasTag((Item)(item = serverPlayer.getItemBySlot(EquipmentSlot.OFFHAND).getItem()), (String)"diversity:slime_detector")) {
                holdingSlimeBlock = true;
            }
            if ((serverLevel = serverPlayer.level()) instanceof ServerLevel) {
                ServerLevel serverLevel2 = serverLevel;
                if (holdingSlimeBlock) {
                    boolean isSlimeChunk;
                    ChunkPos chunkPos = new ChunkPos(serverPlayer.blockPosition());
                    long seed = serverLevel2.getSeed();
                    boolean bl = isSlimeChunk = WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)seed, (long)987234911L).nextInt(10) == 0;
                    if (isSlimeChunk) {
                        serverLevel2.sendParticles((ParticleOptions)ParticleTypes.ITEM_SLIME, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), 10, (double)0.3f, 0.06, (double)0.3f, 0.0);
                        serverLevel2.playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.SLIME_SQUISH, SoundSource.PLAYERS, 0.2f, 0.1f);
                    }
                }
            }
        }
    }
}

