/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.entity.randomSizeFishes;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.inter.entity.ICustomAbstractFish;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={AbstractFish.class})
public abstract class FishEntityMixin
extends WaterAnimal
implements Bucketable,
ICustomAbstractFish {
    @Unique
    private float diversity_Multiloader$size;

    protected FishEntityMixin(EntityType<? extends WaterAnimal> entityType, Level world) {
        super(entityType, world);
        this.diversity_Multiloader$size = (float)(this.random.nextGaussian() * 0.2 + 1.0);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initInject(EntityType<? extends Salmon> entityType, Level world, CallbackInfo ci) {
        this.diversity_Multiloader$reCalculateSize();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveDataInject(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putFloat("diversity:Size", this.diversity_Multiloader$size);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveDataInject(ValueInput valueInput, CallbackInfo ci) {
        this.diversity_Multiloader$size = valueInput.getFloatOr("diversity:Size", 1.0f);
        this.diversity_Multiloader$reCalculateSize();
    }

    @Inject(method={"saveToBucketTag"}, at={@At(value="TAIL")})
    private void saveToBucketTagInject(ItemStack stack, CallbackInfo ci) {
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, nbtCompound -> nbtCompound.putFloat("diversity:Size", this.diversity_Multiloader$getSize()));
    }

    @Inject(method={"loadFromBucketTag"}, at={@At(value="TAIL")})
    private void loadFromBucketTagInject(CompoundTag tag, CallbackInfo ci) {
        if (tag.contains("diversity:Size")) {
            this.diversity_Multiloader$setSize(tag.getFloat("diversity:Size").orElse(Float.valueOf(1.0f)).floatValue());
        }
        this.diversity_Multiloader$reCalculateSize();
    }

    @Override
    public float diversity_Multiloader$getSize() {
        return this.diversity_Multiloader$size;
    }

    @Override
    public void diversity_Multiloader$setSize(float value) {
        this.diversity_Multiloader$size = value;
    }

    @Override
    public void diversity_Multiloader$reCalculateSize() {
        AttributeInstance entityAttributeInstance;
        if (this.diversity_Multiloader$size < 0.6f) {
            this.diversity_Multiloader$size = 0.6f;
        }
        if (this.diversity_Multiloader$size > 1.7f) {
            this.diversity_Multiloader$size = 1.7f;
        }
        if (!ModConfigs.random_size_fishes) {
            this.diversity_Multiloader$size = 1.0f;
        }
        if ((entityAttributeInstance = this.getAttributes().getInstance(Attributes.SCALE)) != null) {
            entityAttributeInstance.setBaseValue((double)this.diversity_Multiloader$size);
        }
    }
}

